package com.autotech.we1l.activities

import android.content.Context
import android.content.Intent
import android.net.Uri
import android.os.Bundle
import android.os.Environment
import android.view.Window
import android.view.WindowManager
import com.autotech.we1l.R
import com.autotech.we1l.app.AppLanguage
import com.autotech.we1l.app.User
import com.autotech.we1l.my_classes.BaseActivity
import com.autotech.we1l.tools.ATTR_IS_UNREGISTERED
import com.autotech.we1l.tools.Language.btn_sign_in_or_sign_up
import com.autotech.we1l.tools.Language.btn_skip
import com.autotech.we1l.tools.SHARED_PREFERENCES_NAME
import com.autotech.we1l.tools.launchMainActivity
import com.thin.downloadmanager.DownloadRequest
import com.thin.downloadmanager.DownloadStatusListenerV1
import com.thin.downloadmanager.ThinDownloadManager
import kotlinx.android.synthetic.main.activity_first_screen.*
import java.io.File

class FirstScreenActivity : BaseActivity() {


    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        AppLanguage.init(this)

        val langFile = File(Environment.getExternalStorageDirectory().absoluteFile, "robots.txt")

        val downloadRequest = DownloadRequest(Uri.parse("https://we1l.com/test/robots.txt"))
                .setDestinationURI(Uri.fromFile(langFile))
                .setStatusListener(object : DownloadStatusListenerV1 {

                    override fun onDownloadComplete(downloadRequest: DownloadRequest) {
//                        AppLanguage.saveLanguageSettings(this@FirstScreenActivity, )
//                        launchFirstActivity(this@FirstScreenActivity)
//                        dialog.dismiss()
                    }

                    override fun onDownloadFailed(downloadRequest: DownloadRequest, errorCode: Int, errorMessage: String) {
//                        dialog.dismiss()
                    }

                    override fun onProgress(downloadRequest: DownloadRequest, totalBytes: Long, downloadedBytes: Long, progress: Int) {
//                        dialog.setProgress(((downloadedBytes * 100) / totalBytes).toInt())
                    }
                })
        val thinDownloadManager = ThinDownloadManager()
        thinDownloadManager.add(downloadRequest)
//        return

        User.load(this)
        User.loadCurrency(this)
        if (User.isValid()) {
            launchMainActivity(this)
            return
        } else {
            val sharedPreferences = getSharedPreferences(SHARED_PREFERENCES_NAME, Context.MODE_PRIVATE)

            if (sharedPreferences.getBoolean(ATTR_IS_UNREGISTERED, false)) {
                launchMainActivity(this)
            }
        }

        // Remove title bar
        this.requestWindowFeature(Window.FEATURE_NO_TITLE)

        // Remove notification bar
        this.window.setFlags(WindowManager.LayoutParams.FLAG_FULLSCREEN, WindowManager.LayoutParams.FLAG_FULLSCREEN)

        setContentView(R.layout.activity_first_screen)

        doAll()
    }

    override fun setupLanguages() {
        sign_in_or_sign_up.text = AppLanguage.getString(btn_sign_in_or_sign_up)
        skip.text = AppLanguage.getString(btn_skip)
    }

    override fun setupViews() {
        sign_in_or_sign_up.setOnClickListener {
            val intent = Intent(this, SignInActivity::class.java)
            startActivity(intent)
            finish()
        }

        skip.setOnClickListener {
            val sharedPreferences = getSharedPreferences(SHARED_PREFERENCES_NAME, Context.MODE_PRIVATE)
            sharedPreferences.edit().putBoolean(ATTR_IS_UNREGISTERED, true).apply()
            val intent = Intent(this, MainActivity::class.java)
            startActivity(intent)
            finish()
        }
    }

    override fun setupClickListeners() {

    }

}
