package com.autotech.we1l.activities

import android.content.Intent
import android.support.v7.app.AppCompatActivity
import android.os.Bundle
import android.util.Log
import android.view.View
import android.widget.Toast
import com.android.volley.VolleyError
import com.autotech.we1l.R
import com.autotech.we1l.app.AppLanguage
import com.autotech.we1l.app.User
import com.autotech.we1l.helpers.InputMap
import com.autotech.we1l.tools.ATTR_SYSTEM_PASSCODE
import com.autotech.we1l.tools.Language
import com.autotech.we1l.tools.REQUEST_PAYMENT_RESULT
import com.autotech.we1l.tools.SYSTEM_PASSCODE
import com.autotech.we1l.volley.IVolleyRequest
import com.autotech.we1l.volley.VolleyRequest
import kotlinx.android.synthetic.main.activity_payment_details.*
import org.json.JSONObject

class PaymentDetailsActivity : AppCompatActivity() {

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_payment_details)

        home.text = AppLanguage.getString(Language.nav_home)

        val inputMap = HashMap<String, String>()

        val string = intent.getStringExtra("URL")

        val index = string.lastIndexOf("/")

        val id = string.substring(index + 1, string.length)

        home.setOnClickListener { onBackPressed() }

        progress_bar.visibility = View.VISIBLE
        home.visibility = View.GONE

        inputMap[ATTR_SYSTEM_PASSCODE] = SYSTEM_PASSCODE
        inputMap["invoice"] = id

        VolleyRequest.getInstance().post(REQUEST_PAYMENT_RESULT, inputMap, object : IVolleyRequest {
            override fun onSuccess(response: JSONObject?) {

                progress_bar.visibility = View.GONE
                home.visibility = View.VISIBLE

                Log.e("JSONObject", response.toString())

                if (response?.getInt("ErrorCode") != 0) {
                    status.text = response?.getString("ErrorMessage")
                    return
                }

                if (!response.getJSONObject("Data").getJSONObject("Data").getBoolean("status")) {
                    status.text = response.getJSONObject("Data").getJSONObject("Data").getString("note")
                    trace.text = "Message : " + response.getJSONObject("Data").getJSONObject("Data").getString("message")
                    return
                }

                status.text = response.getJSONObject("Data").getJSONObject("Data").getString("status_text")
                trace.text = "Trace No. :" + response.getJSONObject("Data").getJSONObject("Data").getString("trace")
                ref_no.text = "Ref No. :" + response.getJSONObject("Data").getJSONObject("Data").getString("ref")
                amount.text = "Amount : " + response.getJSONObject("Data").getJSONObject("Data").getString("amount") + " " + response.getJSONObject("Data").getJSONObject("Data").getString("currency")

                User.deleteCart()
            }

            override fun onFail(error: VolleyError?) {
                status.text = error?.message
                progress_bar.visibility = View.GONE
                home.visibility = View.VISIBLE
            }
        })
    }

    override fun onBackPressed() {
        super.onBackPressed()
        startActivity(Intent(applicationContext, MainActivity::class.java))
    }
}