package com.autotech.we1l.activities

import android.os.Bundle
import android.view.Menu
import android.view.MenuItem
import android.view.View
import com.autotech.we1l.R
import com.autotech.we1l.app.AppLanguage
import com.autotech.we1l.fragments.*
import com.autotech.we1l.items.Order
import com.autotech.we1l.my_classes.BaseActivity
import com.autotech.we1l.tools.ATTR_ORDER
import com.autotech.we1l.tools.Language.btn_check_out
import com.autotech.we1l.tools.Language.btn_request_ad
import com.autotech.we1l.tools.Language.menu_cart
import com.autotech.we1l.tools.Language.menu_notifications
import com.autotech.we1l.tools.Language.txt_v_details_of
import com.autotech.we1l.tools.Language.txt_v_tracking
import com.autotech.we1l.tools.launchCart
import com.autotech.we1l.tools.launchNotifications
import kotlinx.android.synthetic.main.activity_place_holder.*


class PlaceHolderActivity : BaseActivity() {


    companion object {
        const val FRAGMENT_TYPE = "FragmentType"
        const val TYPE_FULL_ITEM = 1
        const val TYPE_CART = 2
        const val TYPE_CHECK_OUT = 3
        const val TYPE_NOTIFICATIONS = 4
        const val TYPE_TRACK_ORDER = 5
        const val TYPE_ORDER_DETAILS = 6
        const val TYPE_REQUEST_AD = 7
    }

    // Views
    lateinit var toolbarView: View

    // Vars
    private var fragmentType = -1

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_place_holder)
        setSupportActionBar(toolbar)

        fragmentType = intent.extras.getInt(FRAGMENT_TYPE)

        doAll()
    }

    override fun setupViews() {

        setSupportActionBar(toolbar)

        toolbarView = toolbar

        supportActionBar?.setDisplayHomeAsUpEnabled(true)

        val fragment = when (fragmentType) {

            TYPE_FULL_ITEM -> {
                val fragment = ProductDetailsFragment()
                fragment.arguments = intent.extras
                fragment
            }

            TYPE_CART -> {
                val fragment = CartFragment()
                supportActionBar?.title = AppLanguage.getString(menu_cart)
                fragment
            }

            TYPE_CHECK_OUT -> {
                val fragment = CheckOutFragment().apply {
                    arguments = intent.extras
                }
                supportActionBar?.title = AppLanguage.getString(btn_check_out)
                fragment
            }

            TYPE_NOTIFICATIONS -> {
                val fragment = NotificationsFragment()
                supportActionBar?.title = AppLanguage.getString(menu_notifications)
                fragment
            }

            TYPE_TRACK_ORDER -> {
                val order = intent.extras!!.getSerializable(ATTR_ORDER) as Order
                val fragment = TrackOrderFragment()
                supportActionBar?.title = "${AppLanguage.getString(txt_v_tracking)} ${order.orderNumber}..."

                fragment.arguments = Bundle().apply {
                    putSerializable(ATTR_ORDER, order)
                }
                fragment
            }

            TYPE_ORDER_DETAILS -> {
                val fragment = OrderDetailsFragment()
                val order = intent.extras!!.getSerializable(ATTR_ORDER) as Order
                supportActionBar?.title = "${AppLanguage.getString(txt_v_details_of)} ${order.orderNumber}"

                fragment.arguments = Bundle().apply {
                    putSerializable(ATTR_ORDER, order)
                }
                fragment
            }

            TYPE_REQUEST_AD -> {
                val fragment = RequestAdFragment()
                supportActionBar?.title = AppLanguage.getString(btn_request_ad).toUpperCase()

                fragment
            }

            else -> null
        }

        fragment?.arguments = intent.extras

        if (fragment != null)
            supportFragmentManager.beginTransaction()
                    .replace(R.id.fragment_place_holder, fragment)
                    .commit()
    }

    override fun setupClickListeners() {

    }

    override fun onOptionsItemSelected(item: MenuItem): Boolean {
        when (item.itemId) {
            android.R.id.home -> {
                onBackPressed()
            }
            R.id.cart -> {
                launchCart(this)
            }
            R.id.notifications -> {
                launchNotifications(this)
            }
        }
        return true
    }

    override fun onCreateOptionsMenu(menu: Menu): Boolean {
        return if (fragmentType == TYPE_CART || fragmentType == TYPE_CHECK_OUT) {
            true
        } else {
            menuInflater.inflate(R.menu.place_holder, menu)
            if (fragmentType == TYPE_NOTIFICATIONS) {
                menu.removeItem(R.id.notifications)
            }
            super.onCreateOptionsMenu(menu)
        }
    }

    override fun setupLanguages() {

    }
}
