package com.autotech.we1l.adapters

import android.content.Context
import android.support.v7.widget.AppCompatImageView
import android.support.v7.widget.RecyclerView
import android.view.View
import android.view.ViewGroup
import com.autotech.we1l.R
import com.autotech.we1l.items.Ad
import com.autotech.we1l.my_classes.BaseAdapter
import com.autotech.we1l.my_classes.BaseViewHolder
import com.autotech.we1l.my_classes.BaseList
import com.autotech.we1l.tools.PicassoUtils


class AdsAdapter(context: Context, data: BaseList<Ad>, onClickListener: OnClickListener<Ad>, val size: String)
    : BaseAdapter<AdsAdapter.Holder, Ad>(context, data, onClickListener) {

    override fun onCreateViewHolder(viewGroup: ViewGroup, pos: Int): Holder {
        val itemView = inflate(R.layout.rv_ad, viewGroup)

        val divideBy = when (size) {
            Ad.Size.SMALL -> 4
            Ad.Size.MID -> 2
            Ad.Size.FULL -> 1
            else -> 1
        }

        val height = viewGroup.measuredHeight
        val width = viewGroup.measuredWidth / divideBy

        itemView.layoutParams = RecyclerView.LayoutParams(width, height).apply {
            val margin = context.resources.getDimension(R.dimen.margin_quarter).toInt()
            setMargins(margin, margin, margin, margin)
        }

        return Holder(itemView)
    }

    override fun onBindViewHolderToItem(holder: Holder, ad: Ad, position: Int) {
        super.onBindViewHolderToItem(holder, ad, position)

        PicassoUtils.getImage(ad.imageUrl, context, holder.adImage)
    }

    class Holder(itemView: View) : BaseViewHolder(itemView) {
        val adImage = findViewById<AppCompatImageView>(R.id.ad_image)
    }

}