package com.autotech.we1l.adapters;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;

import com.autotech.we1l.R;
import com.autotech.we1l.items.BestSeller;
import com.autotech.we1l.tools.PicassoUtils;

import java.util.List;

public class BestSellerAdapter extends RecyclerView.Adapter<BestSellerAdapter.BestSellerViewHolder> {

    private final Context context;
    private final List<BestSeller> bestSellerList;
    private final IClickBestSeller iClickBestSeller;

    public BestSellerAdapter(Context context, List<BestSeller> bestSellerList, IClickBestSeller iClickBestSeller) {
        this.context = context;
        this.bestSellerList = bestSellerList;
        this.iClickBestSeller = iClickBestSeller;
    }

    @NonNull
    @Override
    public BestSellerAdapter.BestSellerViewHolder onCreateViewHolder(@NonNull ViewGroup viewGroup, int i) {
        return new BestSellerViewHolder(LayoutInflater.from(viewGroup.getContext()).inflate(R.layout.viewholder_bestseller_second, viewGroup, false));
    }

    @Override
    public void onBindViewHolder(@NonNull BestSellerAdapter.BestSellerViewHolder viewHolder, int i) {
        BestSeller bestSeller = bestSellerList.get(viewHolder.getAdapterPosition());

        viewHolder.category_name.setText(bestSeller.getBrandName());
        PicassoUtils.INSTANCE.getImage(bestSeller.getImages(), context, viewHolder.category_image, true);

        viewHolder.category_image.setOnClickListener(v -> iClickBestSeller.onClickBestSeller(String.valueOf(bestSeller.getProductId())));
    }

    @Override
    public int getItemCount() {
        return bestSellerList.size();
    }

    static class BestSellerViewHolder extends RecyclerView.ViewHolder {

        public final TextView category_name;
        public final ImageView category_image;

        public BestSellerViewHolder(@NonNull View itemView) {
            super(itemView);

            category_image = itemView.findViewById(R.id.category_image);
            category_name = itemView.findViewById(R.id.category_name);
        }
    }

    public interface IClickBestSeller {
        void onClickBestSeller(String id);
    }
}
