package com.autotech.we1l.adapters

import android.content.Context
import android.support.v7.widget.AppCompatTextView
import android.view.View
import android.view.ViewGroup
import com.autotech.we1l.R
import com.autotech.we1l.items.BreadCrumb
import com.autotech.we1l.my_classes.BaseAdapter
import com.autotech.we1l.my_classes.BaseViewHolder
import com.autotech.we1l.my_classes.BaseList

class BreadCrumbsAdapter(context: Context, data: BaseList<BreadCrumb>, onClickListener: OnClickListener<BreadCrumb>)
    : BaseAdapter<BreadCrumbsAdapter.Holder, BreadCrumb>(context, data, onClickListener) {

    override fun onBindViewHolderToItem(holder: Holder, breadCrumb: BreadCrumb, position: Int) {
        super.onBindViewHolderToItem(holder, breadCrumb, position)
        holder.name.text = breadCrumb.name
    }

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): Holder {
        return Holder(inflate(R.layout.rv_bread_crumb, parent))
    }

    class Holder(itemView: View) : BaseViewHolder(itemView) {
        val name = findViewById<AppCompatTextView>(R.id.level_name)
    }

}