package com.autotech.we1l.adapters

import android.content.Context
import android.support.v7.widget.AppCompatImageView
import android.support.v7.widget.AppCompatTextView
import android.support.v7.widget.CardView
import android.view.View
import android.view.ViewGroup
import android.widget.RelativeLayout
import com.autotech.we1l.R
import com.autotech.we1l.app.AppLanguage
import com.autotech.we1l.items.CartProduct
import com.autotech.we1l.my_classes.BaseAdapter
import com.autotech.we1l.my_classes.BaseViewHolder
import com.autotech.we1l.my_classes.BaseList
import com.autotech.we1l.tools.Language
import com.autotech.we1l.tools.PicassoUtils

class CartItemsAdapter(context: Context, data: BaseList<CartProduct>, onClickListener: OnClickListener<CartProduct>)
    : BaseAdapter<CartItemsAdapter.Holder, CartProduct>(context, data, onClickListener) {

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): Holder {
        return Holder(inflate(R.layout.rv_cart_item, parent))
    }

    override fun onBindViewHolderToItem(holder: Holder, cartItem: CartProduct, position: Int) {
        super.onBindViewHolderToItem(holder, cartItem, position)


        if (cartItem.colorId == 0 && cartItem.product.noColor.productImages.isNotEmpty())
            PicassoUtils.getImage(cartItem.product.noColor.productImages[0], context, holder.itemImage)
        else {
            val colorImages = cartItem.product.colors?.findItemById(cartItem.colorId)?.productImages
            if (colorImages != null && colorImages.isNotEmpty()) {
                PicassoUtils.getImage(colorImages[0], context, holder.itemImage)
            }
        }

        holder.itemPrice.text = cartItem.product.price.toString()
        holder.itemName.text = cartItem.product.name
        holder.item_brand.text = cartItem.product.brandName
        holder.quantity.text = AppLanguage.getString(Language.attr_quantity) + " " + cartItem.quantity.toString()
        if (cartItem.colorUrl != null)
            PicassoUtils.getImage(cartItem.colorUrl!!, context, holder.image)
    }

    fun removeItem(position: Int) {
        data.removeAt(position)

        notifyItemRemoved(position)
    }

    class Holder(itemView: View) : BaseViewHolder(itemView) {
        val viewForeground = findViewById<RelativeLayout>(R.id.view_foreground)
        val itemImage = findViewById<AppCompatImageView>(R.id.item_image)
        val itemPrice = findViewById<AppCompatTextView>(R.id.item_price)
        val itemName = findViewById<AppCompatTextView>(R.id.item_name)
        val item_brand = findViewById<AppCompatTextView>(R.id.item_brand)
        val cardViewColor = findViewById<CardView>(R.id.cardViewColor)
        val image = findViewById<AppCompatImageView>(R.id.image)
        val quantity = findViewById<AppCompatTextView>(R.id.quantity)
    }
}