package com.autotech.we1l.adapters;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;

import com.autotech.we1l.R;
import com.autotech.we1l.items.Category;
import com.autotech.we1l.my_classes.BaseList;
import com.autotech.we1l.tools.PicassoUtils;

public class CategoriesAdapter extends RecyclerView.Adapter<CategoriesAdapter.CategoriesViewHolder> {

    private final Context context;
    private final BaseList<Category> categoryList;
    private final MainCategoriesAdapter.IClickCategory iClickCategory;

    public CategoriesAdapter(Context context, BaseList<Category> categoryList, MainCategoriesAdapter.IClickCategory iClickCategory) {
        this.categoryList = categoryList;
        this.categoryList.remove(0);
        this.context = context;
        this.iClickCategory = iClickCategory;
    }

    @NonNull
    @Override
    public CategoriesAdapter.CategoriesViewHolder onCreateViewHolder(@NonNull ViewGroup viewGroup, int i) {
        return new CategoriesViewHolder(LayoutInflater.from(viewGroup.getContext()).inflate(R.layout.viewholder_category_second, viewGroup, false));
    }

    @Override
    public void onBindViewHolder(@NonNull CategoriesAdapter.CategoriesViewHolder categoriesViewHolder, int i) {
        Category category = this.categoryList.get(categoriesViewHolder.getAdapterPosition());

        categoriesViewHolder.category_name.setText(category.getName());
        PicassoUtils.INSTANCE.getImage(category.getImageUrl(), context, categoriesViewHolder.category_image, true);

        categoriesViewHolder.category_image.setOnClickListener(v -> iClickCategory.onClickCategory(String.valueOf(category.getId())));
    }

    @Override
    public int getItemCount() {
        return this.categoryList.size();
    }

    static class CategoriesViewHolder extends RecyclerView.ViewHolder {

        public final TextView category_name;
        public final ImageView category_image;

        public CategoriesViewHolder(@NonNull View itemView) {
            super(itemView);
            category_image = itemView.findViewById(R.id.category_image);
            category_name = itemView.findViewById(R.id.category_name);
        }
    }

}
