package com.autotech.we1l.adapters

import android.content.Context
import android.support.v7.widget.AppCompatImageView
import android.view.View
import android.view.ViewGroup
import com.autotech.we1l.R
import com.autotech.we1l.items.ColorImage
import com.autotech.we1l.my_classes.BaseAdapter
import com.autotech.we1l.my_classes.BaseViewHolder
import com.autotech.we1l.my_classes.BaseList
import com.autotech.we1l.tools.PicassoUtils

class ColorImagesAdapter(context: Context, data: BaseList<ColorImage>, onClickListener: OnClickListener<ColorImage>)
    : BaseAdapter<ColorImagesAdapter.Holder, ColorImage>(context, data, onClickListener) {

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): Holder {
        return Holder(inflate(R.layout.rv_color, parent))
    }

    override fun onBindViewHolderToItem(holder: Holder, item: ColorImage, position: Int) {
        super.onBindViewHolderToItem(holder, item, position)

        PicassoUtils.getImage(item.colorUrl, context, holder.image)
    }

    class Holder(itemView: View) : BaseViewHolder(itemView) {
        val image = findViewById<AppCompatImageView>(R.id.image)
    }

}