package com.autotech.we1l.adapters

import android.content.Context
import android.support.v7.widget.AppCompatImageView
import android.support.v7.widget.AppCompatTextView
import android.view.View
import android.view.ViewGroup
import com.autotech.we1l.R
import com.autotech.we1l.items.Product
import com.autotech.we1l.my_classes.BaseAdapter
import com.autotech.we1l.my_classes.BaseViewHolder
import com.autotech.we1l.my_classes.BaseList
import com.autotech.we1l.tools.PicassoUtils


class FavoriteAdapter(context: Context, data: BaseList<Product>, onClickListener: OnClickListener<Product>)
    : BaseAdapter<FavoriteAdapter.Holder, Product>(context, data, onClickListener) {

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): Holder {
        return Holder(inflate(R.layout.viewholder_favorite, parent))
    }

    override fun onBindViewHolderToItem(holder: Holder, product: Product, position: Int) {
        super.onBindViewHolderToItem(holder, product, position)

        if (product.noColor.productImages.isNotEmpty())
            PicassoUtils.getImage(product.noColor.productImages[0], context, holder.itemImage)

        holder.itemName.text = product.name
        holder.itemPrice.text = product.price.toString()
        holder.removeFromWishList.setOnClickListener { view ->
            onClickListener.onSpecialClick(view, holder, position, product)
        }
    }

    class Holder(itemView: View) : BaseViewHolder(itemView) {
        val itemImage = findViewById<AppCompatImageView>(R.id.item_image)
        val itemPrice = findViewById<AppCompatTextView>(R.id.item_price)
        val itemName = findViewById<AppCompatTextView>(R.id.item_name)
        val removeFromWishList = findViewById<AppCompatImageView>(R.id.remove_from_wishlist)
    }

}