package com.autotech.we1l.adapters;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;

import com.autotech.we1l.R;
import com.autotech.we1l.items.HotDeals;
import com.autotech.we1l.tools.PicassoUtils;

import java.util.List;

public class HomeHotDealsAdapter extends RecyclerView.Adapter<HomeHotDealsAdapter.HomeHotDealsViewHolder> {

    private final List<HotDeals> hotDealsList;
    private final IHomeHotDealsAdapter iHomeHotDealsAdapter;
    private final Context context;

    public HomeHotDealsAdapter(List<HotDeals> hotDealsList, Context context, IHomeHotDealsAdapter iHomeHotDealsAdapter) {
        this.hotDealsList = hotDealsList;
        this.iHomeHotDealsAdapter = iHomeHotDealsAdapter;
        this.context = context;
    }

    @NonNull
    @Override
    public HomeHotDealsViewHolder onCreateViewHolder(@NonNull ViewGroup viewGroup, int i) {
        return new HomeHotDealsViewHolder(LayoutInflater.from(viewGroup.getContext()).inflate(R.layout.viewholder_home_hot_deals, viewGroup, false));
    }

    @Override
    public void onBindViewHolder(@NonNull HomeHotDealsViewHolder homeHotDealsViewHolder, int i) {
        HotDeals hotDeals = hotDealsList.get(homeHotDealsViewHolder.getAdapterPosition());

        homeHotDealsViewHolder.textViewNumber.setText("#" + (i + 1));
        homeHotDealsViewHolder.textViewTitle.setText(hotDeals.getTitle());

        PicassoUtils.INSTANCE.getImage(hotDeals.getImg(), context, homeHotDealsViewHolder.hot_deal_image, true);

        homeHotDealsViewHolder.hot_deal_image.setOnClickListener(v -> iHomeHotDealsAdapter.onClickHomeHotDeals(hotDeals));
    }

    @Override
    public int getItemCount() {
        return this.hotDealsList.size();
    }

    static class HomeHotDealsViewHolder extends RecyclerView.ViewHolder {

        public final TextView textViewTitle;
        public final TextView textViewNumber;
        public final ImageView hot_deal_image;

        public HomeHotDealsViewHolder(@NonNull View itemView) {
            super(itemView);

            textViewNumber = itemView.findViewById(R.id.textViewNumber);
            textViewTitle = itemView.findViewById(R.id.textViewTitle);
            hot_deal_image = itemView.findViewById(R.id.hot_deal_image);
        }
    }

    public interface IHomeHotDealsAdapter {
        void onClickHomeHotDeals(HotDeals hotDeals);
    }

}