package com.autotech.we1l.adapters

import android.content.Context
import android.view.View
import android.view.ViewGroup
import android.widget.ImageView
import com.autotech.we1l.R
import com.autotech.we1l.items.HotDeal
import com.autotech.we1l.my_classes.BaseAdapter
import com.autotech.we1l.my_classes.BaseViewHolder
import com.autotech.we1l.my_classes.BaseList
import com.autotech.we1l.tools.PicassoUtils

class HotDealsAdapter(context: Context, data: BaseList<HotDeal>, onClickListener: OnClickListener<HotDeal>)
    : BaseAdapter<HotDealsAdapter.Holder, HotDeal>(context, data, onClickListener) {

    override fun onCreateViewHolder(viewGroup: ViewGroup, pos: Int): Holder {
        return Holder(inflate(R.layout.viewholder_hot_deal, viewGroup))
    }

    override fun onBindViewHolderToItem(holder: Holder, hotDeal: HotDeal, position: Int) {
        super.onBindViewHolderToItem(holder, hotDeal, position)

        PicassoUtils.getImage(hotDeal.imageUrl, context, holder.hotDealImage)
    }

    class Holder(itemView: View) : BaseViewHolder(itemView) {
        val hotDealImage = findViewById<ImageView>(R.id.hot_deal_image)
    }
}