package com.autotech.we1l.adapters;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.v4.view.PagerAdapter;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;

import com.autotech.we1l.R;
import com.autotech.we1l.items.Image;
import com.autotech.we1l.tools.PicassoUtils;

import java.util.List;

/**
 * Created by Amjad Alwareh on 2/25/2018.
 */

public class ImageSliderAdapter extends PagerAdapter {

    private final Context context;
    private List<Image> imageList;

    public ImageSliderAdapter(Context context, List<Image> imageList) {
        this.context = context;
        this.setImageList(imageList);
    }

    @Override
    public void destroyItem(@NonNull ViewGroup collection, int position, @NonNull Object view) {
        collection.removeView((View) view);
    }

    @NonNull
    @Override
    public Object instantiateItem(@NonNull ViewGroup collection, int position) {
        LayoutInflater inflater = LayoutInflater.from(context);

        ViewGroup layout = (ViewGroup) inflater.inflate(R.layout.layout_item_image, collection, false);

        ImageView imageView = layout.findViewById(R.id.imageView);

        Image image = getImageList().get(position);

        PicassoUtils.INSTANCE.getImage(image.getImageURL(), collection.getContext(), imageView, true);


        collection.addView(layout, 0);
        return layout;
    }

    @Override
    public int getCount() {
        return getImageList().size();
    }

    @Override
    public boolean isViewFromObject(@NonNull View view, @NonNull Object object) {
        return view == object;
    }

    public List<Image> getImageList() {
        return imageList;
    }

    public void setImageList(List<Image> imageList) {
        this.imageList = imageList;
    }
}
