package com.autotech.we1l.adapters

import android.content.Context
import android.support.v7.widget.AppCompatImageView
import android.view.View
import android.view.ViewGroup
import com.autotech.we1l.R
import com.autotech.we1l.items.Image
import com.autotech.we1l.my_classes.BaseAdapter
import com.autotech.we1l.my_classes.BaseViewHolder
import com.autotech.we1l.my_classes.BaseList
import com.autotech.we1l.tools.PicassoUtils
import com.squareup.picasso.Callback
import uk.co.senab.photoview.PhotoViewAttacher

class ImagesAdapter(context: Context, data: BaseList<Image>)
    : BaseAdapter<ImagesAdapter.Holder, Image>(context, data) {

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): Holder {
        return Holder(inflate(R.layout.rv_image, parent))
    }

    override fun onBindViewHolderToItem(holder: Holder, image: Image, position: Int) {
        super.onBindViewHolderToItem(holder, image, position)

        PicassoUtils.getImage(image.imageURL, context, holder.image, object : Callback {
            override fun onSuccess() {
                val attach = PhotoViewAttacher(holder.image)
                attach.update()
            }

            override fun onError(e: Exception) {}
        }, false)
    }

    class Holder(itemView: View) : BaseViewHolder(itemView) {
        val image = findViewById<AppCompatImageView>(R.id.image)
    }

}