package com.autotech.we1l.adapters

import android.content.Context
import android.support.v7.widget.AppCompatImageView
import android.support.v7.widget.AppCompatTextView
import android.view.View
import android.view.ViewGroup
import com.autotech.we1l.R
import com.autotech.we1l.app.AppLanguage
import com.autotech.we1l.items.InvoiceDetail
import com.autotech.we1l.my_classes.BaseAdapter
import com.autotech.we1l.my_classes.BaseViewHolder
import com.autotech.we1l.my_classes.BaseList
import com.autotech.we1l.tools.Language.attr_quantity
import com.autotech.we1l.tools.Language.attr_total_price
import com.autotech.we1l.tools.PicassoUtils
import kotlinx.android.synthetic.main.rv_invoice_detail.view.*

class InvoiceDetailsAdapter(context: Context, data: BaseList<InvoiceDetail>, onClickListener: OnClickListener<InvoiceDetail>)
    : BaseAdapter<InvoiceDetailsAdapter.Holder, InvoiceDetail>(context, data, onClickListener) {

    override fun onCreateViewHolder(viewGroup: ViewGroup, p1: Int): Holder {
        return Holder(inflate(R.layout.rv_invoice_detail, viewGroup))
    }

    override fun onBindViewHolderToItem(holder: Holder, invoiceDetail: InvoiceDetail, position: Int) {
        super.onBindViewHolderToItem(holder, invoiceDetail, position)
        PicassoUtils.getImage(invoiceDetail.product.noColor.productImages[0], context, holder.productImage)
        holder.productName.text = invoiceDetail.product.name
        holder.quantity.text = invoiceDetail.qty.toString()
        holder.priceOnSale.text = (invoiceDetail.qty * invoiceDetail.priceOnSale).toString()
    }

    class Holder(itemView: View) : BaseViewHolder(itemView) {
        val productImage = findViewById<AppCompatImageView>(R.id.item_image)
        val productName = findViewById<AppCompatTextView>(R.id.item_name)
        val quantity = findViewById<AppCompatTextView>(R.id.quantity)
        val priceOnSale = findViewById<AppCompatTextView>(R.id.price_on_sale)

        init {
            itemView.quantity_title.text = AppLanguage.getString(attr_quantity)
            itemView.total_price_title.text = AppLanguage.getString(attr_total_price)
        }
    }
}