package com.autotech.we1l.adapters;

import android.content.Context;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.HorizontalScrollView;
import android.widget.ImageView;
import android.widget.TextView;

import com.autotech.we1l.R;
import com.autotech.we1l.items.Category;
import com.autotech.we1l.items.ParentCategory;
import com.autotech.we1l.my_classes.BaseList;
import com.autotech.we1l.tools.PicassoUtils;

import java.util.List;

public class MainCategoriesAdapter extends RecyclerView.Adapter<MainCategoriesAdapter.CategoriesViewHolder> {

    private BaseList<ParentCategory> parentCategoryList;
    private final Context context;
    private final IClickCategory iClickCategory;

    public MainCategoriesAdapter(BaseList<ParentCategory> parentCategoryList, Context context, IClickCategory iClickCategory) {
        this.setParentCategoryList(parentCategoryList);
        this.context = context;
        this.iClickCategory = iClickCategory;
    }

    @NonNull
    @Override
    public CategoriesViewHolder onCreateViewHolder(@NonNull ViewGroup viewGroup, int i) {
        return new CategoriesViewHolder(LayoutInflater.from(viewGroup.getContext()).inflate(R.layout.viewholder_main_category, viewGroup, false));
    }

    @Override
    public void onBindViewHolder(@NonNull CategoriesViewHolder categoriesViewHolder, int position) {
        ParentCategory parentCategory = getParentCategoryList().get(categoriesViewHolder.getAdapterPosition());

        Category category = parentCategory.getCategoryList().get(0);

        categoriesViewHolder.textViewTitle.setText(parentCategory.getName());

        PicassoUtils.INSTANCE.getImage(category.getImageUrl(), context, categoriesViewHolder.category_image, true);
        categoriesViewHolder.category_name.setText(category.getName());

        categoriesViewHolder.category_image.setOnClickListener(v -> iClickCategory.onClickCategory(String.valueOf(category.getId())));

        CategoriesAdapter subCategoriesAdapter = new CategoriesAdapter(context, parentCategory.getCategoryList(), iClickCategory);
        categoriesViewHolder.recyclerView.setAdapter(subCategoriesAdapter);
    }

    @Override
    public int getItemCount() {
        return getParentCategoryList().size();
    }

    private List<ParentCategory> getParentCategoryList() {
        return parentCategoryList;
    }

    private void setParentCategoryList(BaseList<ParentCategory> parentCategoryList) {
        this.parentCategoryList = parentCategoryList;
    }

    static class CategoriesViewHolder extends RecyclerView.ViewHolder {

        final TextView textViewTitle;
        final TextView category_name;
        final ImageView category_image;
        final RecyclerView recyclerView;
        final HorizontalScrollView horizontalScrollView;

        CategoriesViewHolder(View itemView) {
            super(itemView);

            textViewTitle = itemView.findViewById(R.id.textViewTitle);
            category_image = itemView.findViewById(R.id.category_image);
            horizontalScrollView = itemView.findViewById(R.id.horizontalScrollView);

            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
                horizontalScrollView.setNestedScrollingEnabled(true);
            }

            category_name = itemView.findViewById(R.id.category_name);

            recyclerView = itemView.findViewById(R.id.recyclerView);
            recyclerView.setHasFixedSize(true);

            LinearLayoutManager layoutManager = new GridLayoutManager(itemView.getContext(), 2);
            layoutManager.setOrientation(LinearLayoutManager.HORIZONTAL);
            recyclerView.setLayoutManager(layoutManager);
        }
    }

    public interface IClickCategory {
        void onClickCategory(String id);
    }
}
