package com.autotech.we1l.adapters

import android.content.Context
import android.support.v7.widget.AppCompatImageView
import android.support.v7.widget.AppCompatTextView
import android.view.View
import android.view.ViewGroup
import com.autotech.we1l.R
import com.autotech.we1l.app.User
import com.autotech.we1l.items.MiniProduct
import com.autotech.we1l.my_classes.BaseAdapter
import com.autotech.we1l.my_classes.BaseViewHolder
import com.autotech.we1l.my_classes.BaseList
import com.autotech.we1l.tools.PicassoUtils

class MiniProductsAdapter(context: Context, data: BaseList<MiniProduct>, onClickListener: OnClickListener<MiniProduct>)
    : BaseAdapter<MiniProductsAdapter.Holder, MiniProduct>(context, data, onClickListener) {

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): Holder {
        return Holder(inflate(R.layout.rv_mini_product, parent))
    }

    override fun onBindViewHolderToItem(holder: Holder, miniProduct: MiniProduct, position: Int) {
        super.onBindViewHolderToItem(holder, miniProduct, position)

        holder.itemName.text = miniProduct.name

        holder.addToWishList.setOnClickListener {
            onClickListener.onSpecialClick(holder.addToWishList, holder, position, miniProduct)
        }

        PicassoUtils.getImage(miniProduct.imageURL, context, holder.itemImage)

        if (!User.isValid()) {
            holder.addToWishList.visibility = View.GONE
        } else {
            holder.addToWishList.visibility = View.VISIBLE
        }

    }

    class Holder(itemView: View) : BaseViewHolder(itemView) {
        val itemImage = findViewById<AppCompatImageView>(R.id.item_image)
        val itemName = findViewById<AppCompatTextView>(R.id.item_name)
        val addToWishList = findViewById<AppCompatImageView>(R.id.add_to_wishlist)
    }

}