package com.autotech.we1l.adapters

import android.content.Context
import android.support.v7.widget.AppCompatTextView
import android.view.ViewGroup
import android.view.View
import android.widget.LinearLayout
import com.autotech.we1l.R
import com.autotech.we1l.items.Navigation
import com.autotech.we1l.my_classes.BaseAdapter
import com.autotech.we1l.my_classes.BaseViewHolder
import com.autotech.we1l.my_classes.BaseList

class NavigationAdapter(context: Context, data: BaseList<Navigation>, clickListener: OnClickListener<Navigation>)
    : BaseAdapter<NavigationAdapter.Holder, Navigation>(context, data, clickListener) {

    private var selectedPosition = 0

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): Holder {
        return Holder(inflate(R.layout.rv_navigation, parent))
    }

    override fun onBindViewHolderToItem(holder: Holder, navigation: Navigation, position: Int) {
        super.onBindViewHolderToItem(holder, navigation, position)
        holder.name.text = navigation.name

        if (position == selectedPosition) {
            holder.background.setBackgroundColor(context.resources.getColor(R.color.black_10))
        } else {
            holder.background.setBackgroundColor(context.resources.getColor(R.color.white))
        }

    }

    fun setSelectedPosition(selectedPosition: Int) {
        val tempSelectedPosition = this.selectedPosition
        this.selectedPosition = selectedPosition
        notifyItemChanged(tempSelectedPosition)
        notifyItemChanged(selectedPosition)
    }

    fun getSelectedPosition(): Int {
        return selectedPosition
    }

    class Holder(itemView: View) : BaseViewHolder(itemView) {
        val name = findViewById<AppCompatTextView>(R.id.navigation_name)
        val background = findViewById<LinearLayout>(R.id.background)
    }
}