package com.autotech.we1l.adapters

import android.support.v7.app.AppCompatActivity
import android.support.v7.widget.RecyclerView
import android.util.DisplayMetrics
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.ImageView
import android.widget.TextView
import com.autotech.we1l.R
import com.autotech.we1l.items.NewArrivals
import com.autotech.we1l.tools.PicassoUtils

class NewArrivalAdapter(private val newArrivalsList: List<NewArrivals>, private val activity: AppCompatActivity
                        , private var iNewArrivalAdapter: INewArrivalAdapter) : RecyclerView.Adapter<NewArrivalAdapter.NewArrivalHolder>() {

    override fun onCreateViewHolder(viewGroup: ViewGroup, i: Int): NewArrivalHolder {
        return NewArrivalHolder(LayoutInflater.from(viewGroup.context).inflate(R.layout.viewholder_new_arrival, viewGroup, false), activity)
    }

    override fun onBindViewHolder(newArrivalHolder: NewArrivalHolder, i: Int) {
        val newArrivals = newArrivalsList[newArrivalHolder.adapterPosition]

        newArrivalHolder.textViewName.text = newArrivals.name
        newArrivalHolder.textViewPrice.text = StringBuilder()
                .append(newArrivals.price)
                .append(" ")
                .append(newArrivals.symbol).toString()

        PicassoUtils.getImage(newArrivals.image, activity, newArrivalHolder.imageView, true)


        newArrivalHolder.imageView.setOnClickListener { iNewArrivalAdapter.onClickNewArrival(newArrivals) }
    }

    override fun getItemCount(): Int {
        return newArrivalsList.size
    }

    inner class NewArrivalHolder(itemView: View, activity: AppCompatActivity?) : RecyclerView.ViewHolder(itemView) {


        var textViewName: TextView = itemView.findViewById(R.id.textViewName)
        var textViewPrice: TextView = itemView.findViewById(R.id.textViewPrice)
        var imageView: ImageView = itemView.findViewById(R.id.imageView)

        init {

            val display = activity?.windowManager?.defaultDisplay
            val outMetrics = DisplayMetrics()
            display?.getMetrics(outMetrics)

            val dpWidth = outMetrics.widthPixels
            val dpHeight = outMetrics.heightPixels
            //Log.e("dpDPdp-dpWidth", dpWidth.toString())
            //Log.e("dpDPdp-dpHeight", dpHeight.toString())

            itemView.layoutParams.width = (dpWidth / 2)
            itemView.layoutParams.height = (dpHeight / 6)
        }

    }

    interface INewArrivalAdapter {
        fun onClickNewArrival(newArrivals: NewArrivals)
    }
}