package com.autotech.we1l.adapters

import android.content.Context
import android.support.v7.widget.AppCompatTextView
import android.view.View
import android.view.ViewGroup
import com.autotech.we1l.R
import com.autotech.we1l.items.Notification
import com.autotech.we1l.my_classes.BaseAdapter
import com.autotech.we1l.my_classes.BaseViewHolder
import com.autotech.we1l.my_classes.BaseList
import com.autotech.we1l.tools.Tools

class NotificationsAdapter(context: Context, data: BaseList<Notification>, onClickListener: OnClickListener<Notification>)
    : BaseAdapter<NotificationsAdapter.Holder, Notification>(context, data, onClickListener) {

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): Holder {
        return Holder(inflate(R.layout.rv_notification, parent))
    }

    override fun onBindViewHolderToItem(holder: Holder, notification: Notification, position: Int) {
        super.onBindViewHolderToItem(holder, notification, position)
        holder.title.text = notification.title
        holder.date.text = Tools.calendarToString_FullDate(notification.date)
        holder.content.text = notification.content
    }

    class Holder(itemView: View) : BaseViewHolder(itemView) {
        val title = findViewById<AppCompatTextView>(R.id.title)
        val date = findViewById<AppCompatTextView>(R.id.date)
        val content = findViewById<AppCompatTextView>(R.id.content)
    }
}