package com.autotech.we1l.adapters

import android.content.Context
import android.support.v7.widget.AppCompatTextView
import android.view.View
import android.view.ViewGroup
import android.widget.LinearLayout
import com.autotech.we1l.R
import com.autotech.we1l.app.AppLanguage
import com.autotech.we1l.items.Order
import com.autotech.we1l.my_classes.BaseAdapter
import com.autotech.we1l.my_classes.BaseViewHolder
import com.autotech.we1l.my_classes.BaseList
import com.autotech.we1l.tools.Language.attr_address
import com.autotech.we1l.tools.Language.attr_awb_number
import com.autotech.we1l.tools.Language.attr_order_date
import com.autotech.we1l.tools.Language.attr_order_number
import com.autotech.we1l.tools.Language.attr_status
import com.autotech.we1l.tools.Language.txt_v_order_details
import com.autotech.we1l.tools.Language.txt_v_track_order
import com.autotech.we1l.tools.Tools
import kotlinx.android.synthetic.main.rv_order.view.*

class OrdersAdapter(context: Context, data: BaseList<Order>, onClickListener: OnClickListener<Order>)
    : BaseAdapter<OrdersAdapter.Holder, Order>(context, data, onClickListener) {


    override fun onCreateViewHolder(container: ViewGroup, viewType: Int): Holder {
        return Holder(inflate(R.layout.rv_order, container))
    }

    override fun onBindViewHolderToItem(holder: Holder, order: Order, position: Int) {
        super.onBindViewHolderToItem(holder, order, position)

        holder.orderNumber.text = order.orderNumber
        holder.orderDate.text = Tools.calendarToString_FullDate(order.date)
        holder.awbNumber.text = order.awbNumber
        holder.status.text = order.status
        holder.address.text = order.address

        holder.trackOrder.setOnClickListener {
            onClickListener.onSpecialClick(holder.trackOrder, holder, position, order)
        }

        holder.orderDetails.setOnClickListener {
            onClickListener.onSpecialClick(holder.orderDetails, holder, position, order)
        }
    }

    class Holder(itemView: View) : BaseViewHolder(itemView) {
        val orderNumber = findViewById<AppCompatTextView>(R.id.order_number)
        val orderDate = findViewById<AppCompatTextView>(R.id.order_date)
        val awbNumber = findViewById<AppCompatTextView>(R.id.awb_number)
        val status = findViewById<AppCompatTextView>(R.id.status)
        val address = findViewById<AppCompatTextView>(R.id.address)

        val trackOrder = findViewById<LinearLayout>(R.id.track_order)
        val orderDetails = findViewById<LinearLayout>(R.id.order_details)

        init {
            itemView.order_number_title.text = AppLanguage.getString(attr_order_number)
            itemView.order_date_title.text = AppLanguage.getString(attr_order_date)
            itemView.awb_number_title.text = AppLanguage.getString(attr_awb_number)
            itemView.status_title.text = AppLanguage.getString(attr_status)
            itemView.address_title.text = AppLanguage.getString(attr_address)
            itemView.order_details_title.text = AppLanguage.getString(txt_v_order_details)
            itemView.track_order_title.text = AppLanguage.getString(txt_v_track_order)
        }
    }

}