package com.autotech.we1l.adapters

import android.annotation.SuppressLint
import android.content.Context
import android.support.v7.widget.AppCompatImageView
import android.support.v7.widget.AppCompatTextView
import android.view.View
import android.view.ViewGroup
import com.autotech.we1l.R
import com.autotech.we1l.app.User
import com.autotech.we1l.items.Product
import com.autotech.we1l.my_classes.BaseAdapter
import com.autotech.we1l.my_classes.BaseViewHolder
import com.autotech.we1l.my_classes.BaseList
import com.autotech.we1l.tools.PicassoUtils

class ProductsAdapter(context: Context, data: BaseList<Product>, onClickListener: OnClickListener<Product>, private val isHorizontal: Boolean)
    : BaseAdapter<ProductsAdapter.Holder, Product>(context, data, onClickListener) {

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): Holder {
        return Holder(inflate(R.layout.rv_product, parent))
    }

    @SuppressLint("SetTextI18n")
    override fun onBindViewHolderToItem(holder: Holder, product: Product, position: Int) {
        super.onBindViewHolderToItem(holder, product, position)

        if (isHorizontal) {
            holder.itemView.layoutParams =
                    ViewGroup.LayoutParams(ViewGroup.LayoutParams.WRAP_CONTENT, ViewGroup.LayoutParams.MATCH_PARENT)
        }

        holder.price.text = "${product.price} ${User.loadVisibleCurrency(context)?.name}"
        holder.itemName.text = product.name

        if (product.noColor.productImages.isNotEmpty())
            PicassoUtils.getImage(product.noColor.productImages[0], context, holder.itemImage)

    }

    class Holder(itemView: View) : BaseViewHolder(itemView) {
        val price = findViewById<AppCompatTextView>(R.id.price)
        val itemImage = findViewById<AppCompatImageView>(R.id.item_image)
        val itemName = findViewById<AppCompatTextView>(R.id.item_name)
    }

}