package com.autotech.we1l.adapters

import android.content.Context
import android.support.v7.widget.AppCompatImageView
import android.view.View
import android.view.ViewGroup
import android.widget.LinearLayout
import com.autotech.we1l.R
import com.autotech.we1l.app.AppLanguage
import com.autotech.we1l.items.Promotion
import com.autotech.we1l.my_classes.BaseAdapter
import com.autotech.we1l.my_classes.BaseViewHolder
import com.autotech.we1l.my_classes.BaseList
import com.autotech.we1l.tools.Language.btn_submit_to_promotion
import com.autotech.we1l.tools.PicassoUtils
import kotlinx.android.synthetic.main.rv_promotion.view.*

class PromotionsAdapter(context: Context, data: BaseList<Promotion>, onClickListener: OnClickListener<Promotion>)
    : BaseAdapter<PromotionsAdapter.Holder, Promotion>(context, data, onClickListener) {

    override fun onCreateViewHolder(container: ViewGroup, position: Int): Holder {
        return Holder(inflate(R.layout.rv_promotion, container))
    }

    override fun onBindViewHolderToItem(holder: Holder, promotion: Promotion, position: Int) {
        super.onBindViewHolderToItem(holder, promotion, position)

        PicassoUtils.getImage(promotion.imageURL, context, holder.promotionImage, false)

        holder.submitToPromotion.setOnClickListener {
            onClickListener.onSpecialClick(holder.submitToPromotion, holder, position, promotion)
        }
    }

    class Holder(itemView: View) : BaseViewHolder(itemView) {
        val promotionImage = findViewById<AppCompatImageView>(R.id.promotion_image)
        val submitToPromotion = findViewById<LinearLayout>(R.id.submit_to_promotion)

        init {
            itemView.submit_to_promotion_title.text = AppLanguage.getString(btn_submit_to_promotion)
        }
    }
}