package com.autotech.we1l.adapters

import android.content.Context
import android.view.View
import android.view.ViewGroup
import android.widget.TextView
import com.autotech.we1l.R
import com.autotech.we1l.items.Purchase
import com.autotech.we1l.my_classes.BaseAdapter
import com.autotech.we1l.my_classes.BaseViewHolder
import com.autotech.we1l.my_classes.BaseList
import com.autotech.we1l.tools.Tools

class PurchaseHistoryAdapter(context: Context, data: BaseList<Purchase>, onClickListener: OnClickListener<Purchase>)
    : BaseAdapter<PurchaseHistoryAdapter.PurchaseHistoryViewHolder, Purchase>(context, data, onClickListener) {

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): PurchaseHistoryViewHolder {
        return PurchaseHistoryViewHolder(inflate(R.layout.viewholder_purchased_history, parent))
    }

    override fun onBindViewHolderToItem(holder: PurchaseHistoryViewHolder, purchase: Purchase, position: Int) {
        super.onBindViewHolderToItem(holder, purchase, position)
        holder.textViewOrderDate.text = Tools.calendarToString_Date(purchase.date)
        holder.textViewOrderNumber.text = "Order Number : " + purchase.orderNumber
        holder.textViewOrderStatus.text = "Status : " + purchase.status
    }

    class PurchaseHistoryViewHolder(itemView: View) : BaseViewHolder(itemView) {
        val textViewOrderStatus: TextView = findViewById(R.id.textView_order_status)
        val textViewOrderNumber: TextView = findViewById(R.id.textView_order_number)
        val textViewOrderDate: TextView = findViewById(R.id.textView_order_date)
    }

}