package com.autotech.we1l.adapters

import android.content.Context
import android.support.v7.widget.AppCompatImageView
import android.support.v7.widget.AppCompatTextView
import android.view.View
import android.view.ViewGroup
import com.autotech.we1l.R
import com.autotech.we1l.items.SlideImage
import com.autotech.we1l.my_classes.BaseAdapter
import com.autotech.we1l.my_classes.BaseViewHolder
import com.autotech.we1l.my_classes.BaseList
import com.autotech.we1l.tools.PicassoUtils

class SliderImagesAdapter(context: Context, data: BaseList<SlideImage>) : BaseAdapter<SliderImagesAdapter.Holder, SlideImage>(context, data) {

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): Holder {
        return Holder(inflate(R.layout.rv_slider_image, parent))
    }

    override fun onBindViewHolderToItem(holder: Holder, slideImage: SlideImage, position: Int) {
        super.onBindViewHolderToItem(holder, slideImage, position)

        PicassoUtils.getImage(slideImage.imageUrl, context, holder.slideImage)

        holder.title1.text = slideImage.title1
        holder.title2.text = slideImage.title2
        holder.title3.text = slideImage.title3

    }

    class Holder(itemView: View) : BaseViewHolder(itemView) {
        val slideImage = findViewById<AppCompatImageView>(R.id.slide_image)
        val title1 = findViewById<AppCompatTextView>(R.id.title_1)
        val title2 = findViewById<AppCompatTextView>(R.id.title_2)
        val title3 = findViewById<AppCompatTextView>(R.id.title_3)
    }
}