package com.autotech.we1l.adapters

import android.support.v7.app.AppCompatActivity
import android.support.v7.widget.AppCompatImageView
import android.support.v7.widget.AppCompatTextView
import android.support.v7.widget.CardView
import android.util.DisplayMetrics
import android.view.Gravity
import android.view.View
import android.view.ViewGroup
import com.autotech.we1l.R
import com.autotech.we1l.items.Category
import com.autotech.we1l.my_classes.BaseAdapter
import com.autotech.we1l.my_classes.BaseViewHolder
import com.autotech.we1l.my_classes.BaseList
import com.autotech.we1l.tools.PicassoUtils
import android.widget.FrameLayout


class SubCategoriesAdapter(var activity: AppCompatActivity, categories: BaseList<Category>, onClickListener: OnClickListener<Category>)
    : BaseAdapter<SubCategoriesAdapter.Holder, Category>(activity, categories, onClickListener) {

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): Holder {
        return Holder(inflate(R.layout.rv_category, parent), activity)
    }

    override fun onBindViewHolderToItem(holder: Holder, category: Category, position: Int) {
        super.onBindViewHolderToItem(holder, category, position)

        holder.categoryName.text = category.name

        PicassoUtils.getImage(category.imageUrl, context, holder.categoryImage)
    }

    class Holder(itemView: View, activity: AppCompatActivity) : BaseViewHolder(itemView) {
        private val subcategoryCard = findViewById<CardView>(R.id.subcategory_card)
        val categoryName = findViewById<AppCompatTextView>(R.id.subcategory_name)
        val categoryImage = findViewById<AppCompatImageView>(R.id.category_image)

        init {

            val display = activity.windowManager?.defaultDisplay
            val outMetrics = DisplayMetrics()

            display?.getMetrics(outMetrics)

            val dpWidth = outMetrics.widthPixels
            val dpHeight = outMetrics.heightPixels

            val params = FrameLayout.LayoutParams(ViewGroup.LayoutParams.WRAP_CONTENT, ViewGroup.LayoutParams.WRAP_CONTENT, Gravity.CENTER_HORIZONTAL)

            params.width = (dpWidth / 2) - 64
            params.height = (dpHeight / 4) - 64

            params.marginStart = 32
            params.leftMargin = 32
            params.marginEnd = 32
            params.rightMargin = 32
            params.topMargin = 32
            params.bottomMargin = 32

            subcategoryCard.layoutParams = params
        }
    }
}