package com.autotech.we1l.adapters

import android.content.Context
import android.support.v4.content.ContextCompat
import android.support.v7.widget.AppCompatImageView
import android.support.v7.widget.RecyclerView
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.ImageView
import android.widget.TextView
import com.autotech.we1l.R
import com.autotech.we1l.items.TodayTrending
import com.autotech.we1l.tools.PicassoUtils

class TodayTrendingAdapter(private val todayTrendingList: List<TodayTrending>, private val context: Context, private val iTodayTrendingAdapter: ITodayTrendingAdapter) : RecyclerView.Adapter<TodayTrendingAdapter.TodayTrendingViewHolder>() {

    override fun onCreateViewHolder(viewGroup: ViewGroup, i: Int): TodayTrendingViewHolder {
        return TodayTrendingViewHolder(LayoutInflater.from(viewGroup.context).inflate(R.layout.viewholder_today_trending, viewGroup, false))
    }

    override fun onBindViewHolder(todayTrendingViewHolder: TodayTrendingViewHolder, i: Int) {
        val todayTrending = todayTrendingList[todayTrendingViewHolder.adapterPosition]

        PicassoUtils.getImage(todayTrending.images, context, todayTrendingViewHolder.imageView, true)

        if (todayTrending.liked) {
            todayTrendingViewHolder.imageViewLike.setImageDrawable(ContextCompat.getDrawable(context, R.drawable.ic_favorite_red))
        } else {
            todayTrendingViewHolder.imageViewLike.setImageDrawable(ContextCompat.getDrawable(context, R.drawable.ic_bottom_favorite_inactive))
        }

        todayTrendingViewHolder.textViewBrandName.text = todayTrending.brandName
        todayTrendingViewHolder.textViewProductName.text = todayTrending.name

        todayTrendingViewHolder.imageView.setOnClickListener { iTodayTrendingAdapter.onClickTodayTrending(todayTrending) }
    }

    override fun getItemCount(): Int {
        return todayTrendingList.size
    }

    inner class TodayTrendingViewHolder(itemView: View) : RecyclerView.ViewHolder(itemView) {

        var imageViewLike: AppCompatImageView = itemView.findViewById(R.id.imageViewLike)
        var imageView: ImageView = itemView.findViewById(R.id.imageView)
        var textViewProductName: TextView = itemView.findViewById(R.id.textViewProductName)
        var textViewBrandName: TextView = itemView.findViewById(R.id.textViewBrandName)

    }

    interface ITodayTrendingAdapter {
        fun onClickTodayTrending(todayTrending: TodayTrending)
    }

}
