package com.autotech.we1l.adapters

import android.content.Context
import android.support.v7.widget.AppCompatTextView
import android.view.View
import android.view.ViewGroup
import com.autotech.we1l.R
import com.autotech.we1l.app.AppLanguage
import com.autotech.we1l.items.TrackOrder
import com.autotech.we1l.my_classes.BaseAdapter
import com.autotech.we1l.my_classes.BaseViewHolder
import com.autotech.we1l.my_classes.BaseList
import com.autotech.we1l.tools.Language.attr_awb_number
import com.autotech.we1l.tools.Language.attr_order_number
import com.autotech.we1l.tools.Language.attr_status
import kotlinx.android.synthetic.main.rv_track_order.view.*

class TrackOrderAdapter(context: Context, data: BaseList<TrackOrder>, onClickListener: OnClickListener<TrackOrder>)
    : BaseAdapter<TrackOrderAdapter.Holder, TrackOrder>(context, data, onClickListener) {

    override fun onCreateViewHolder(container: ViewGroup, viewType: Int): Holder {
        return Holder(inflate(R.layout.rv_track_order, container))
    }

    override fun onBindViewHolderToItem(holder: Holder, trackOrder: TrackOrder, position: Int) {
        super.onBindViewHolderToItem(holder, trackOrder, position)

        holder.orderNumber.text = trackOrder.orderNumber
        holder.awbNumber.text = trackOrder.awbNumber
        holder.status.text = trackOrder.status
    }

    class Holder(itemView: View) : BaseViewHolder(itemView) {
        val orderNumber = findViewById<AppCompatTextView>(R.id.order_number)
        val awbNumber = findViewById<AppCompatTextView>(R.id.awb_number)
        val status = findViewById<AppCompatTextView>(R.id.status)

        init {
            itemView.order_number_title.text = AppLanguage.getString(attr_order_number)
            itemView.awb_number_title.text = AppLanguage.getString(attr_awb_number)
            itemView.status_title.text = AppLanguage.getString(attr_status)
        }
    }


}