package com.autotech.we1l.app

import android.support.multidex.MultiDexApplication
import android.support.v7.app.AppCompatActivity
import com.android.volley.Request
import com.android.volley.RequestQueue
import com.android.volley.toolbox.Volley
import com.autotech.we1l.R
import com.autotech.we1l.tools.LocaleHelper
import uk.co.chrisjenx.calligraphy.CalligraphyConfig
import java.util.*

//import com.google.firebase.FirebaseApp;
class MyApp : MultiDexApplication() {
    private var mRequestQueue: RequestQueue? = null
    override fun onCreate() {
        super.onCreate()
        instance = this
        CalligraphyConfig.initDefault(CalligraphyConfig.Builder()
                .setDefaultFontPath("fonts/cairo.ttf")
                .setFontAttrId(R.attr.fontPath)
                .build()
        )

//        FirebaseApp.initializeApp(getApplicationContext());
    }

    private val requestQueue: RequestQueue?
        get() {
            if (mRequestQueue == null) {
                mRequestQueue = Volley.newRequestQueue(applicationContext)
            }
            mRequestQueue!!.cache.clear()
            return mRequestQueue
        }

    fun <T> addToRequestQueue(req: Request<T>) {
        req.tag = TAG
        requestQueue!!.add(req)
    }

    fun changeLocale(locale: Locale, activity: AppCompatActivity) {
        val locale = Locale(LocaleHelper.getLanguage(this))
        val config = resources.configuration
        config.setLocale(locale)
        applicationContext.resources.updateConfiguration(
                config,
                applicationContext.resources.displayMetrics
        )
        Locale.setDefault(locale)
    }

    companion object {
        const val LOCALE = "Locale"
        private const val LANGUAGE_ENGLISH = "en"
        const val LANGUAGE_PORTUGUESE = "pt"
        private val LOCALE_ENGLISH = Locale("en")
        private val LOCALE_PORTUGUESE = Locale("pt", "PR")
        var language = LANGUAGE_ENGLISH
        val TAG: String = MyApp::class.java.simpleName
        @JvmStatic
        var instance: MyApp? = null
            private set

        val changeToLocale: Locale
            get() = if (language == LANGUAGE_ENGLISH) {
                LOCALE_PORTUGUESE
            } else {
                LOCALE_ENGLISH
            }
    }
}