package com.autotech.we1l.app

import android.content.Context
import com.autotech.we1l.activities.MainActivity
import com.autotech.we1l.items.CartProduct
import com.autotech.we1l.items.Currency
import com.autotech.we1l.my_classes.BaseList
import com.autotech.we1l.tools.*
import org.json.JSONObject

class User(var id: Int, var fullName: String, var email: String, var zipCode: String, var phone: String,
           var mobile: String, var insuranceName: String, var insuranceNumber: String, var imageUrl: String) {


    constructor(userJSON: JSONObject) : this(userJSON.getInt(ATTR_ID),
            userJSON.getString(ATTR_FULLNAME),
            userJSON.getString(ATTR_EMAIL),
            userJSON.getString(ATTR_ZIPCODE),
            userJSON.getString(ATTR_PHONE),
            userJSON.getString(ATTR_MOBILE),
            userJSON.getString(ATTR_INSURANCE_NAME),
            userJSON.getString(ATTR_INSURANCE_NAME),
            userJSON.getString(ATTR_IMAGE_URL))

    companion object {
        val cartProducts = BaseList<CartProduct>()

        fun deleteCart(){
            cartProducts.clear()
        }

        fun removeFromCart(position: Int) {
            cartProducts.removeAt(position)
            //MainActivity.updateCartBadge.update(cartProducts.size)
        }

        fun addToCart(cartProduct: CartProduct) {
            cartProducts.add(cartProduct)
            //MainActivity.updateCartBadge.update(cartProducts.size)
        }

        fun addToCart(position: Int, cartProduct: CartProduct) {
            cartProducts.add(position, cartProduct)
            MainActivity.updateCartBadge.update(cartProducts.size)
        }

        var instance: User? = null

        fun init(userJSON: JSONObject) {
            instance = User(userJSON)
        }

        fun save(context: Context) {
            val sharedPreferences = context.getSharedPreferences(SHARED_PREFERENCES_NAME, Context.MODE_PRIVATE)
            sharedPreferences.edit().putInt(ATTR_ID, instance!!.id)
                    .putString(ATTR_FULLNAME, instance!!.fullName)
                    .putString(ATTR_EMAIL, instance!!.email)
                    .putString(ATTR_ZIPCODE, instance!!.zipCode)
                    .putString(ATTR_PHONE, instance!!.phone)
                    .putString(ATTR_MOBILE, instance!!.mobile)
                    .putString(ATTR_INSURANCE_NAME, instance!!.insuranceName)
                    .putString(ATTR_INSURANCE_NUMBER, instance!!.insuranceNumber)
                    .putString(ATTR_IMAGE_URL, instance!!.imageUrl)
                    .apply()
        }

        fun load(context: Context) {
            val sharedPreferences = context.getSharedPreferences(SHARED_PREFERENCES_NAME, Context.MODE_PRIVATE)
            instance = User(
                    sharedPreferences.getInt(ATTR_ID, -1),
                    sharedPreferences.getString(ATTR_FULLNAME, "")!!,
                    sharedPreferences.getString(ATTR_EMAIL, "")!!,
                    sharedPreferences.getString(ATTR_ZIPCODE, "")!!,
                    sharedPreferences.getString(ATTR_PHONE, "")!!,
                    sharedPreferences.getString(ATTR_MOBILE, "")!!,
                    sharedPreferences.getString(ATTR_INSURANCE_NAME, "")!!,
                    sharedPreferences.getString(ATTR_INSURANCE_NUMBER, "")!!,
                    sharedPreferences.getString(ATTR_IMAGE_URL, "")!!
            )
        }

        fun delete(context: Context) {
            val sharedPreferences = context.getSharedPreferences(SHARED_PREFERENCES_NAME, Context.MODE_PRIVATE)
            sharedPreferences.edit().putInt(ATTR_ID, -1)
                    .putString(ATTR_FULLNAME, "")
                    .putString(ATTR_EMAIL, "")
                    .putString(ATTR_ZIPCODE, "")
                    .putString(ATTR_PHONE, "")
                    .putString(ATTR_MOBILE, "")
                    .putString(ATTR_INSURANCE_NAME, "")
                    .putString(ATTR_INSURANCE_NUMBER, "")
                    .putString(ATTR_IMAGE_URL, "")
                    .apply()
            cartProducts.clear()
            instance = null
        }

        fun saveCurrency(context: Context, currency: Currency) {
            val sharedPreferences = context.getSharedPreferences(SHARED_PREFERENCES_NAME, Context.MODE_PRIVATE)
            sharedPreferences.edit()
                    .putInt(ATTR_CURRENCY_ID, currency.id!!)
                    .putString(ATTR_CURRENCY_NAME, currency.name)
                    .putString(ATTR_COUNTRY, currency.countryName)
                    .apply()
        }

        fun loadCurrency(context: Context): Currency? {
            val sharedPreferences = context.getSharedPreferences(SHARED_PREFERENCES_NAME, Context.MODE_PRIVATE)
            val currencyId = sharedPreferences.getInt(ATTR_CURRENCY_ID, -1)
            val currencyName = sharedPreferences.getString(ATTR_CURRENCY_NAME, "")
            val countryName = sharedPreferences.getString(ATTR_COUNTRY, "")

            return Currency(currencyId, currencyName!!, countryName!!)
        }

        fun saveVisibleCurrency(context: Context, currency: Currency) {
            val sharedPreferences = context.getSharedPreferences(SHARED_PREFERENCES_NAME, Context.MODE_PRIVATE)
            sharedPreferences.edit()
                    .putInt("${ATTR_CURRENCY_ID}_VISIBLE", currency.id!!)
                    .putString("${ATTR_CURRENCY_NAME}_VISIBLE", currency.name)
                    .putString("${ATTR_COUNTRY}_VISIBLE", currency.countryName)
                    .apply()
        }

        fun loadVisibleCurrency(context: Context): Currency? {
            val sharedPreferences = context.getSharedPreferences(SHARED_PREFERENCES_NAME, Context.MODE_PRIVATE)
            val currencyId = sharedPreferences.getInt("${ATTR_CURRENCY_ID}_VISIBLE", loadCurrency(context)?.id!!)
            val currencyName = sharedPreferences.getString("${ATTR_CURRENCY_NAME}_VISIBLE", loadCurrency(context)?.name)
            val countryName = sharedPreferences.getString("${ATTR_COUNTRY}_VISIBLE", loadCurrency(context)?.countryName)
            if (currencyId == -1) {
                return Currency(1, "", "")
            }
            return Currency(currencyId, currencyName!!, countryName!!)
        }

        fun saveUserLanguage(context: Context?, lang: String) {
            val sharedPreferences = context?.getSharedPreferences(SHARED_PREFERENCES_NAME, Context.MODE_PRIVATE)
            sharedPreferences?.edit()
                    ?.putString("${ATTR_LANGUAGE}_User", lang)
                    ?.apply()
        }

        fun saveUserLanguageId(context: Context?, lang: Int) {
            val sharedPreferences = context?.getSharedPreferences(SHARED_PREFERENCES_NAME, Context.MODE_PRIVATE)
            sharedPreferences?.edit()
                    ?.putInt("${ATTR_LANGUAGE}_User_ID", lang)
                    ?.apply()
        }

        fun getUserLanguage(context: Context): String? {
            val sharedPreferences = context.getSharedPreferences(SHARED_PREFERENCES_NAME, Context.MODE_PRIVATE)
            return sharedPreferences.getString("${ATTR_LANGUAGE}_User", "1")
        }

        fun getUserLanguageId(context: Context): Int? {
            val sharedPreferences = context.getSharedPreferences(SHARED_PREFERENCES_NAME, Context.MODE_PRIVATE)
            return sharedPreferences.getInt("${ATTR_LANGUAGE}_User_ID", 1)
        }

        fun isValid(): Boolean {
            return instance != null && instance?.id != -1
        }

    }

    override fun toString(): String {
        return "User(id=$id, fullName='$fullName', email='$email', zipCode='$zipCode', phone='$phone', mobile='$mobile', insuranceName='$insuranceName', insuranceNumber='$insuranceNumber', imageUrl='$imageUrl')"
    }


}