package com.autotech.we1l.fragments

import android.os.Bundle
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.Toast
import com.android.volley.VolleyError
import com.autotech.we1l.R
import com.autotech.we1l.app.AppLanguage
import com.autotech.we1l.helpers.InputMap
import com.autotech.we1l.my_classes.BaseFragment
import com.autotech.we1l.tools.*
import com.autotech.we1l.tools.Language.btn_send_message
import com.autotech.we1l.tools.Language.err_no_email
import com.autotech.we1l.tools.Language.err_no_message
import com.autotech.we1l.tools.Language.err_no_name
import com.autotech.we1l.tools.Language.hint_email
import com.autotech.we1l.tools.Language.hint_name
import com.autotech.we1l.tools.Language.hint_your_message
import com.autotech.we1l.tools.Language.toast_done
import com.autotech.we1l.volley.IVolleyRequest
import com.autotech.we1l.volley.VolleyRequest
import kotlinx.android.synthetic.main.fragment_contact_us.*
import kotlinx.android.synthetic.main.fragment_contact_us.textViewTitle
import kotlinx.android.synthetic.main.fragment_settings.*
import org.json.JSONObject
import java.util.*

class ContactUsFragment : BaseFragment() {

    override fun onCreateView(inflater: LayoutInflater, container: ViewGroup?, savedInstanceState: Bundle?): View? {
        rootView = inflater.inflate(R.layout.fragment_contact_us, container, false)
        return rootView
    }

    override fun setupLanguages() {
        super.setupLanguages()
        editTextFullName.hint = AppLanguage.getString(hint_name)
        editTextEmail.hint = AppLanguage.getString(hint_email)
        editTextMessage.hint = AppLanguage.getString(hint_your_message)

        send_message.text = AppLanguage.getString(btn_send_message)
        textViewTitle.text = AppLanguage.getString(Language.txt_help).toUpperCase(Locale.getDefault())
    }

    override fun setupClickListeners() {
        send_message.setOnClickListener {
            when {
                editTextFullName.text.toString().trim().isEmpty() -> {
                    Toast.makeText(context, AppLanguage.getString(err_no_name), Toast.LENGTH_LONG).show()
                    return@setOnClickListener
                }
                editTextEmail.text.toString().trim().isEmpty() -> {
                    Toast.makeText(context, AppLanguage.getString(err_no_email), Toast.LENGTH_LONG).show()
                    return@setOnClickListener
                }
                editTextMessage.text.toString().trim().isEmpty() -> {
                    Toast.makeText(context, AppLanguage.getString(err_no_message), Toast.LENGTH_LONG).show()
                    return@setOnClickListener
                }
            }

            VolleyRequest.getInstance()
                    .post(REQUEST_CONTACT_US, InputMap().apply {
                        put(ATTR_SYSTEM_PASSCODE, SYSTEM_PASSCODE)
                        put(ATTR_NAME, editTextFullName.text.toString().trim())
                        put(ATTR_EMAIL, editTextEmail.text.toString().trim())
                        put(ATTR_MESSAGE, editTextMessage.text.toString().trim())
                    }, object : IVolleyRequest {

                        override fun onSuccess(response: JSONObject?) {
                            when (response!!.getInt(ATTR_ERROR_CODE)) {
                                CODE_OK -> {
                                    editTextFullName.setText("")
                                    editTextEmail.setText("")
                                    editTextMessage.setText("")
                                    Toast.makeText(context, AppLanguage.getString(toast_done), Toast.LENGTH_LONG).show()
                                }
                            }
                        }

                        override fun onFail(errorListener: VolleyError?) {

                        }

                    })
        }
    }

    override fun crucialRequests() {

    }
}