package com.autotech.we1l.fragments

import android.os.Bundle
import android.support.v7.widget.RecyclerView
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.Toast
import com.android.volley.VolleyError
import com.autotech.we1l.R
import com.autotech.we1l.adapters.HotDealsAdapter
import com.autotech.we1l.app.AppLanguage
import com.autotech.we1l.app.User
import com.autotech.we1l.helpers.InputMap
import com.autotech.we1l.items.HotDeal
import com.autotech.we1l.my_classes.BaseAdapter
import com.autotech.we1l.my_classes.BaseFragment
import com.autotech.we1l.my_classes.BaseList
import com.autotech.we1l.my_interfaces.IOnBackPressedListener
import com.autotech.we1l.tools.*
import com.autotech.we1l.tools.Language.err_no_internet_connection
import com.autotech.we1l.tools.Language.err_server_connection_error
import com.autotech.we1l.tools.Language.prompt_please_retry
import com.autotech.we1l.volley.IVolleyRequest
import com.autotech.we1l.volley.VolleyRequest
import kotlinx.android.synthetic.main.fragment_hot_deals.*
import kotlinx.android.synthetic.main.fragment_hot_deals.refresh_layout
import kotlinx.android.synthetic.main.fragment_hot_deals.textViewTitle
import kotlinx.android.synthetic.main.fragment_settings.*
import org.json.JSONObject
import pub.devrel.easypermissions.EasyPermissions
import java.util.*

class HotDealsFragment : BaseFragment(), IOnBackPressedListener {

    // Vars:
    private lateinit var sharedImageUrl: String

    // Lists:
    private val hotDeals = BaseList<HotDeal>()

    // Adapters:
    private lateinit var hotDealsAdapter: HotDealsAdapter

    override fun onCreateView(inflater: LayoutInflater, container: ViewGroup?, savedInstanceState: Bundle?): View? {
        rootView = inflater.inflate(R.layout.fragment_hot_deals, container, false)
        return rootView
    }

    override fun setupViews() {
        hotDealsAdapter = HotDealsAdapter(context!!, hotDeals, object : BaseAdapter.OnClickListener<HotDeal> {
            override fun onClick(holder: RecyclerView.ViewHolder, position: Int, hotDeal: HotDeal) {
                launchProductDetails(context!!, hotDeal.product.id.toString())
            }
        })

        Tools.setupRV(hot_deals_rv, hotDealsAdapter)
        textViewTitle.text = AppLanguage.getString(Language.txt_hot_deal).toUpperCase(Locale.getDefault())
    }

    override fun setupClickListeners() {
        refresh_layout.setOnRefreshListener {
            crucialRequests()
        }
    }

    override fun crucialRequests() {
        getHotDeals()
    }

    private fun getHotDeals() {
        val inputMap = InputMap()
        inputMap[ATTR_SYSTEM_PASSCODE] = SYSTEM_PASSCODE
        inputMap[ATTR_LANGUAGE] = User.getUserLanguageId(context!!)!!.toString()
        if (!isNetworkAvailable(context!!)) {
            Toast.makeText(context, AppLanguage.getString(err_no_internet_connection), Toast.LENGTH_LONG).show()
            noData(hot_deals_rv, AppLanguage.getString(prompt_please_retry))
            return
        }

        loading(hot_deals_rv)

        VolleyRequest.getInstance().post(REQUEST_TODAY_HOT_DEALS, inputMap, object : IVolleyRequest {
            override fun onSuccess(response: JSONObject?) {
                if (refresh_layout != null)
                    refresh_layout.isRefreshing = false
                when (response!!.getInt(ATTR_ERROR_CODE)) {
                    CODE_OK -> {
                        hotDeals.clear()
                        val data = response.getJSONObject(ATTR_DATA).getJSONArray(ATTR_DATA)
                        for (i in 0 until data.length()) {
                            hotDeals.add(HotDeal(data.getJSONObject(i)))
                        }
                        hotDealsAdapter.updateData(hotDeals)

                        if (hotDeals.isEmpty()) noData(hot_deals_rv) else showData(hot_deals_rv)
                    }
                }
            }

            override fun onFail(errorListener: VolleyError?) {
                if (refresh_layout != null)
                    refresh_layout.isRefreshing = false
                noData(hot_deals_rv, AppLanguage.getString(prompt_please_retry))
                Toast.makeText(context, AppLanguage.getString(err_server_connection_error), Toast.LENGTH_LONG).show()
            }
        }).apply { requestsArray.add(this) }
    }

    override fun onBackPressed(): Boolean {
        return false
    }

}