package com.autotech.we1l.fragments

import android.os.Bundle
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import com.autotech.we1l.R
import com.autotech.we1l.adapters.NotificationsAdapter
import com.autotech.we1l.app.User
import com.autotech.we1l.items.Notification
import com.autotech.we1l.my_classes.BaseAdapter
import com.autotech.we1l.my_classes.BaseFragment
import com.autotech.we1l.my_classes.BaseList
import com.autotech.we1l.tools.PicassoUtils
import kotlinx.android.synthetic.main.fragment_notifications.*
import java.util.*

class NotificationsFragment : BaseFragment() {

    // helpers
    private val loremipsum = "Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum."

    // Adapters
    private lateinit var notificationsAdapter: NotificationsAdapter

    override fun onCreateView(inflater: LayoutInflater, container: ViewGroup?, savedInstanceState: Bundle?): View? {
        rootView = inflater.inflate(R.layout.fragment_notifications, container, false)
        return rootView
    }

    override fun setupViews() {

        if (User.instance != null) {
            PicassoUtils.getImage(User.instance!!.imageUrl, context!!, user_image)
            username.text = User.instance!!.fullName
        } else
            PicassoUtils.getImage("https://images.pexels.com/photos/555790/pexels-photo-555790.png?auto=compress&cs=tinysrgb&h=350",
                    context!!, user_image)

        val notifications = BaseList<Notification>().apply {
            add(Notification("title1", loremipsum, Calendar.getInstance()))
            add(Notification("title2", loremipsum, Calendar.getInstance()))
            add(Notification("title3", loremipsum, Calendar.getInstance()))
            add(Notification("title4", loremipsum, Calendar.getInstance()))
        }

        notificationsAdapter = NotificationsAdapter(context!!, notifications, object : BaseAdapter.OnClickListener<Notification> {

        })

//        Tools.setupRV(notifications_rv, notificationsAdapter)
    }

    override fun setupClickListeners() {

    }

    override fun crucialRequests() {

    }


}