package com.autotech.we1l.fragments

import android.os.Bundle
import android.support.v7.widget.RecyclerView
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import com.autotech.we1l.R
import com.autotech.we1l.adapters.InvoiceDetailsAdapter
import com.autotech.we1l.items.InvoiceDetail
import com.autotech.we1l.items.Order
import com.autotech.we1l.my_classes.BaseAdapter
import com.autotech.we1l.my_classes.BaseFragment
import com.autotech.we1l.tools.ATTR_ORDER
import com.autotech.we1l.tools.Tools
import com.autotech.we1l.tools.launchProductDetails
import kotlinx.android.synthetic.main.fragment_order_details.*

class OrderDetailsFragment : BaseFragment() {

    // Vars:
    private lateinit var order: Order

    // Adapters:
    private lateinit var invoiceDetailsAdapter: InvoiceDetailsAdapter

    override fun onCreateView(inflater: LayoutInflater, container: ViewGroup?, savedInstanceState: Bundle?): View? {
        rootView = inflater.inflate(R.layout.fragment_order_details, container, false)

        order = (arguments!!.getSerializable(ATTR_ORDER) as Order?)!!

        return rootView
    }

    override fun setupViews() {
        invoiceDetailsAdapter = InvoiceDetailsAdapter(context!!, order.invoiceDetails, object : BaseAdapter.OnClickListener<InvoiceDetail> {
            override fun onClick(holder: RecyclerView.ViewHolder, position: Int, invoiceDetail: InvoiceDetail) {
                launchProductDetails(context!!, invoiceDetail.product.id.toString())
            }
        })

        Tools.setupRV(invoice_details_rv, invoiceDetailsAdapter)

    }

    override fun setupClickListeners() {

    }

    override fun crucialRequests() {
    }

}