package com.autotech.we1l.fragments

import android.os.Bundle
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.Toast
import com.android.volley.VolleyError
import com.autotech.we1l.R
import com.autotech.we1l.adapters.TrackOrderAdapter
import com.autotech.we1l.app.AppLanguage
import com.autotech.we1l.helpers.InputMap
import com.autotech.we1l.items.Order
import com.autotech.we1l.items.TrackOrder
import com.autotech.we1l.my_classes.BaseAdapter
import com.autotech.we1l.my_classes.BaseFragment
import com.autotech.we1l.my_classes.BaseList
import com.autotech.we1l.tools.*
import com.autotech.we1l.tools.Language.err_no_internet_connection
import com.autotech.we1l.tools.Language.err_server_connection_error
import com.autotech.we1l.tools.Language.txt_enter_awb
import com.autotech.we1l.volley.IVolleyRequest
import com.autotech.we1l.volley.VolleyRequest
import kotlinx.android.synthetic.main.fragment_track_order.*
import org.json.JSONObject

class TrackOrderFragment : BaseFragment() {

    // Argument Vars:
    //private var order: Order? = null

    // Lists:
    private val trackOrders = BaseList<TrackOrder>()

    // Adapters:
    private lateinit var trackOrdersAdapter: TrackOrderAdapter

    override fun onCreateView(inflater: LayoutInflater, container: ViewGroup?, savedInstanceState: Bundle?): View? {
        rootView = inflater.inflate(R.layout.fragment_track_order, container, false)

        return rootView
    }

    override fun setupViews() {
        textViewEnter.text = AppLanguage.getString(txt_enter_awb)
    }

    override fun setupClickListeners() {
        swipe_refresh_layout.setOnRefreshListener {
            getTrackOrders()
        }
        send.setOnClickListener { getTrackOrders() }

        if (arguments?.getSerializable(ATTR_ORDER) != null) {
            editTextOrderNumber.setText((arguments?.getSerializable(ATTR_ORDER) as Order).orderNumber.toString().trim())
            getTrackOrders()
        }
    }

    private fun getTrackOrders() {
        val inputMap = InputMap()

        inputMap[ATTR_SYSTEM_PASSCODE] = SYSTEM_PASSCODE
        if (editTextOrderNumber.text.toString().startsWith("awb", true))
            inputMap[ATTR_AWB_NUMBER] = editTextOrderNumber.text.toString().trim()
        else
            inputMap[ATTR_ORDER_NUMBER] = editTextOrderNumber.text.toString().trim()

        if (editTextOrderNumber.text == null) {
            Toast.makeText(context, "Some fields are empty", Toast.LENGTH_LONG).show()
            return
        }

        if (!isNetworkAvailable(context!!)) {
            Toast.makeText(context, AppLanguage.getString(err_no_internet_connection), Toast.LENGTH_LONG).show()
            return
        }

        ll_search.visibility = View.GONE
        progress_bar.visibility = View.VISIBLE

        VolleyRequest.getInstance()
                .post(REQUEST_TRACK_ORDERS, inputMap, object : IVolleyRequest {
                    override fun onSuccess(response: JSONObject?) {

                        swipe_refresh_layout.isRefreshing = false
                        progress_bar.visibility = View.GONE

                        when (response!!.getInt(ATTR_ERROR_CODE)) {
                            CODE_OK -> {

                                val data = response.getJSONObject(ATTR_DATA).getJSONArray(ATTR_DATA)
                                for (i in 0 until data.length()) {
                                    trackOrders.add(TrackOrder(data.getJSONObject(i)))
                                }

                                trackOrdersAdapter = TrackOrderAdapter(context!!, trackOrders, object : BaseAdapter.OnClickListener<TrackOrder> {

                                })

                                swipe_refresh_layout.visibility = View.VISIBLE
                                Tools.setupRV(track_orders_rv, trackOrdersAdapter)

                                if (trackOrders.isEmpty()) ll_search.visibility = View.VISIBLE
                            }

                            14 -> {
                                Toast.makeText(context, response.getString("ErrorMessage"), Toast.LENGTH_LONG).show()
                                ll_search.visibility = View.VISIBLE
                            }
                        }
                    }

                    override fun onFail(error: VolleyError?) {
                        swipe_refresh_layout.isRefreshing = false
                        Toast.makeText(context, AppLanguage.getString(err_server_connection_error), Toast.LENGTH_LONG).show()
                    }
                }).apply { requestsArray.add(this) }

    }

    override fun crucialRequests() {
    }
}