package com.autotech.we1l.fragments.dialog_fragments

import android.os.Bundle
import android.support.v4.app.DialogFragment
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.Toast
import com.android.volley.VolleyError
import com.autotech.we1l.R
import com.autotech.we1l.app.AppLanguage
import com.autotech.we1l.app.User
import com.autotech.we1l.fragments.AdsFragment
import com.autotech.we1l.helpers.InputMap
import com.autotech.we1l.items.Ad
import com.autotech.we1l.tools.*
import com.autotech.we1l.tools.Language.attr_advertiser
import com.autotech.we1l.tools.Language.attr_title
import com.autotech.we1l.tools.Language.btn_get_ad
import com.autotech.we1l.tools.Language.btn_share_ad
import com.autotech.we1l.tools.Language.err_email_address_invalid
import com.autotech.we1l.tools.Language.err_empty_fields
import com.autotech.we1l.tools.Language.err_server_connection_error
import com.autotech.we1l.tools.Language.hint_content
import com.autotech.we1l.tools.Language.hint_email
import com.autotech.we1l.tools.Language.hint_mobile
import com.autotech.we1l.tools.Language.hint_name
import com.autotech.we1l.tools.Language.toast_done
import com.autotech.we1l.volley.IVolleyRequest
import com.autotech.we1l.volley.VolleyRequest
import kotlinx.android.synthetic.main.dialog_fragment_ad.*
import org.json.JSONObject

class AdDetailsDialogFragment : DialogFragment() {

    // Data
    private lateinit var ad: Ad

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)

        ad = (arguments!!.getSerializable(ATTR_AD) as Ad?)!!
    }


    override fun onCreateView(inflater: LayoutInflater, container: ViewGroup?, savedInstanceState: Bundle?): View? {
        return inflater.inflate(R.layout.dialog_fragment_ad, container, false)
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)
        setupLanguages()
        setupViews()
    }

    private fun setupViews() {

        title.text = ad.title
        advertiser.text = ad.advertiser
        content.text = ad.content

        if (User.isValid()) {
            input_data_layout.visibility = View.GONE
        }

        get_ad.setOnClickListener {
            if (!User.isValid()) {
                if (name.editText!!.text.toString().trim().isNotEmpty()
                        && email.editText!!.text.toString().trim().isNotEmpty()
                        && mobile.editText!!.text.toString().trim().isNotEmpty()) {

                    if (Tools.isEmailValid(email.editText!!.text!!.trim().toString())) {
                        get_ad.isEnabled = false
                        VolleyRequest.getInstance()
                                .post(REQUEST_GET_AD_UNREG, InputMap().apply {
                                    put(ATTR_SYSTEM_PASSCODE, SYSTEM_PASSCODE)
                                    put(ATTR_NAME, name.editText!!.text.toString().trim())
                                    put(ATTR_EMAIL, email.editText!!.text.toString().trim())
                                    put(ATTR_TEL, mobile.editText!!.text.toString().trim())
                                    put(ATTR_ELAN, ad.id.toString())
                                }, object : IVolleyRequest {

                                    override fun onSuccess(response: JSONObject?) {
                                        get_ad.isEnabled = true
                                        when (response!!.getInt(ATTR_ERROR_CODE)) {
                                            CODE_OK -> {
                                                dismiss()
                                                Toast.makeText(context, AppLanguage.getString(toast_done), Toast.LENGTH_LONG).show()
                                            }
                                        }
                                    }

                                    override fun onFail(errorListener: VolleyError?) {
                                        get_ad.isEnabled = true
                                        Toast.makeText(context, AppLanguage.getString(err_server_connection_error), Toast.LENGTH_LONG).show()
                                    }
                                })
                    } else {
                        Toast.makeText(context, AppLanguage.getString(err_email_address_invalid), Toast.LENGTH_LONG).show()
                        return@setOnClickListener
                    }
                } else {
                    Toast.makeText(context, AppLanguage.getString(err_empty_fields), Toast.LENGTH_LONG).show()
                    return@setOnClickListener
                }
            } else {
                get_ad.isEnabled = false
                VolleyRequest.getInstance()
                        .post(REQUEST_GET_AD_REG, InputMap().apply {
                            put(ATTR_SYSTEM_PASSCODE, SYSTEM_PASSCODE)
                            put(ATTR_CUSTOMER, User.instance!!.id.toString())
                            put(ATTR_ELAN, ad.id.toString())
                        }, object : IVolleyRequest {

                            override fun onSuccess(response: JSONObject?) {
                                get_ad.isEnabled = true
                                when (response!!.getInt(ATTR_ERROR_CODE)) {
                                    CODE_OK -> {
                                        dismiss()
                                        Toast.makeText(context, AppLanguage.getString(toast_done), Toast.LENGTH_LONG).show()
                                    }
                                }
                            }

                            override fun onFail(errorListener: VolleyError?) {
                                get_ad.isEnabled = true
                                Toast.makeText(context, AppLanguage.getString(err_server_connection_error), Toast.LENGTH_LONG).show()
                            }
                        })
            }
        }

        share_ad.setOnClickListener {
            (parentFragment as AdsFragment).sharedAdImageUrl = ad.imageUrl
            ShareFileUtil.shareFile(parentFragment!!, ad.imageUrl, ad.title, ad.id.toString())
        }
    }

    private fun setupLanguages() {
        title_title.text = AppLanguage.getString(attr_title)
        advertiser_title.text = AppLanguage.getString(attr_advertiser)
        content_title.text = AppLanguage.getString(hint_content)
        name.hint = AppLanguage.getString(hint_name)
        email.hint = AppLanguage.getString(hint_email)
        mobile.hint = AppLanguage.getString(hint_mobile)

        get_ad.text = AppLanguage.getString(btn_get_ad)
        share_ad.text = AppLanguage.getString(btn_share_ad)
    }

}