package com.autotech.we1l.fragments.dialog_fragments

import android.annotation.SuppressLint
import android.os.Bundle
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.view.WindowManager
import com.autotech.we1l.R
import com.autotech.we1l.app.AppLanguage
import com.autotech.we1l.app.User
import com.autotech.we1l.my_classes.BaseDialogFragment
import com.autotech.we1l.tools.ATTR_PRICE
import com.autotech.we1l.tools.ATTR_PRIVATE_CODE
import com.autotech.we1l.tools.ATTR_PUBLIC_CODE
import com.autotech.we1l.tools.Language.attr_total_price_is
import com.autotech.we1l.tools.Language.btn_proceed
import com.autotech.we1l.tools.Language.dialog_proceed_to_check_out
import com.autotech.we1l.tools.launchCheckOut
import kotlinx.android.synthetic.main.dialog_fragment_cart_bill_price.*

class CartBillPriceDialogFragment : BaseDialogFragment() {

    companion object {
        const val TAG = "CartBillPriceDialogFragment"
    }

    private var privateCode: String? = ""
    private var publicCode: String? = ""

    private var priceValue = 0f

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        activity?.window?.setLayout(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT)
        activity?.window?.setFlags(WindowManager.LayoutParams.FLAG_NOT_FOCUSABLE, WindowManager.LayoutParams.FLAG_NOT_FOCUSABLE)

        priceValue = arguments?.getFloat(ATTR_PRICE)!!
        publicCode = arguments?.getString(ATTR_PUBLIC_CODE)
        privateCode = arguments?.getString(ATTR_PRIVATE_CODE)

        setStyle(STYLE_NO_FRAME, android.R.style.Theme_Holo)
    }

    override fun onCreateView(inflater: LayoutInflater, container: ViewGroup?, savedInstanceState: Bundle?): View? {
        rootView = LayoutInflater.from(context).inflate(R.layout.dialog_fragment_cart_bill_price, null, false)
        return rootView
    }

    @SuppressLint("SetTextI18n")
    override fun setupViews() {
        price.text = "$priceValue ${User.loadVisibleCurrency(context!!)!!.name}"

        proceed.setOnClickListener {
            launchCheckOut(context!!, priceValue, if (publicCode == null) "" else publicCode!!,
                    if (privateCode == null) "" else privateCode!!)
            dismiss()
        }
    }

    override fun setupLanguages() {
        total_price_title.text = AppLanguage.getString(attr_total_price_is)
        proceed_to_check_out_title.text = AppLanguage.getString(dialog_proceed_to_check_out)
        proceed.text = AppLanguage.getString(btn_proceed)
    }

}