package com.autotech.we1l.fragments.dialog_fragments

import android.annotation.SuppressLint
import android.app.AlertDialog
import android.app.Dialog
import android.os.Bundle
import android.view.LayoutInflater
import android.widget.Toast
import com.android.volley.VolleyError
import com.autotech.we1l.app.User
import com.autotech.we1l.R
import com.autotech.we1l.app.AppLanguage
import com.autotech.we1l.helpers.InputMap
import com.autotech.we1l.my_classes.BaseDialogFragment
import com.autotech.we1l.tools.*
import com.autotech.we1l.tools.Language.btn_change_password
import com.autotech.we1l.tools.Language.err_empty_fields
import com.autotech.we1l.tools.Language.err_generic_error
import com.autotech.we1l.tools.Language.err_password_length
import com.autotech.we1l.tools.Language.err_passwords_dont_match
import com.autotech.we1l.tools.Language.err_server_connection_error
import com.autotech.we1l.tools.Language.hint_new_password
import com.autotech.we1l.tools.Language.hint_new_password_confirmation
import com.autotech.we1l.tools.Language.hint_old_password
import com.autotech.we1l.tools.Language.toast_password_updated
import com.autotech.we1l.volley.IVolleyRequest
import com.autotech.we1l.volley.VolleyRequest
import kotlinx.android.synthetic.main.dialog_password_change.*
import org.json.JSONObject

class ChangePasswordDialogFragment : BaseDialogFragment() {

    //    private lateinit var oldPassword: TextInputLayout
//    private lateinit var newPassword: TextInputLayout
//    private lateinit var newPasswordConfirmation: TextInputLayout
//    private lateinit var changePassword: AppCompatButton

    @SuppressLint("InflateParams")
    override fun onCreateDialog(savedInstanceState: Bundle?): Dialog {
        rootView = LayoutInflater.from(context).inflate(R.layout.dialog_password_change, null, false)

        return AlertDialog.Builder(context!!)
                .setView(rootView)
                .create()
    }

    override fun setupViews() {

        change_password.setOnClickListener {

            if (old_password.editText!!.text!!.isEmpty() || new_password.editText!!.text!!.isEmpty() || new_password_confirm.editText!!.text!!.isEmpty()) {
                Toast.makeText(context, AppLanguage.getString(err_empty_fields), Toast.LENGTH_LONG).show()
                return@setOnClickListener
            }

            if (new_password.editText!!.text.toString().trim() != new_password_confirm.editText!!.text.toString().trim()) {
                Toast.makeText(context, AppLanguage.getString(err_passwords_dont_match), Toast.LENGTH_LONG).show()
                return@setOnClickListener
            }

            if (new_password.editText!!.text.toString().trim().length < 6) {
                Toast.makeText(context, AppLanguage.getString(err_password_length), Toast.LENGTH_LONG).show()
                return@setOnClickListener
            }

            disableAll()

            val inputMap = InputMap().apply {
                put(ATTR_SYSTEM_PASSCODE, SYSTEM_PASSCODE)
                put(ATTR_EMAIL, User.instance!!.email)
                put(ATTR_CUSTOMER, User.instance!!.id.toString())
                put(ATTR_OLD_PASSWORD, old_password.editText!!.text.toString().trim())
                put(ATTR_NEW_PASSWORD, new_password.editText!!.text.toString().trim())
            }

            VolleyRequest.getInstance()
                    .post(REQUEST_CHANGE_PASSWORD, inputMap, object : IVolleyRequest {

                        override fun onSuccess(response: JSONObject?) {
                            when (response!!.getInt(ATTR_ERROR_CODE)) {
                                CODE_OK -> {
                                    Toast.makeText(context, AppLanguage.getString(toast_password_updated), Toast.LENGTH_LONG).show()
                                    dismiss()
                                }
                                CODE_MISSING_DATA -> {
                                    Toast.makeText(context, AppLanguage.getString(err_generic_error), Toast.LENGTH_LONG).show()
                                    enableAll()
                                }
                            }
                        }

                        override fun onFail(errorListener: VolleyError?) {
                            Toast.makeText(context, AppLanguage.getString(err_server_connection_error), Toast.LENGTH_LONG).show()
                            enableAll()
                        }
                    })
        }
    }

    override fun setupLanguages() {
        old_password.hint = AppLanguage.getString(hint_old_password)
        new_password.hint = AppLanguage.getString(hint_new_password)
        new_password_confirm.hint = AppLanguage.getString(hint_new_password_confirmation)
        change_password.text = AppLanguage.getString(btn_change_password)
    }

    private fun disableAll() {
        old_password.isEnabled = false
        new_password.isEnabled = false
        new_password_confirm.isEnabled = false
        change_password.isEnabled = false
    }

    private fun enableAll() {
        old_password.isEnabled = true
        new_password.isEnabled = true
        new_password_confirm.isEnabled = true
        change_password.isEnabled = true
    }

}