package com.autotech.we1l.fragments.dialog_fragments

import android.annotation.SuppressLint
import android.app.AlertDialog
import android.app.Dialog
import android.os.Bundle
import android.view.LayoutInflater
import android.view.View
import com.autotech.we1l.R
import com.autotech.we1l.activities.MainActivity
import com.autotech.we1l.app.AppLanguage
import com.autotech.we1l.app.User
import com.autotech.we1l.my_classes.BaseDialogFragment
import com.autotech.we1l.tools.*
import com.autotech.we1l.tools.Language.attr_added_store_credit
import com.autotech.we1l.tools.Language.attr_final_bill
import com.autotech.we1l.tools.Language.attr_remaining_bill
import com.autotech.we1l.tools.Language.attr_remaining_store_credit
import com.autotech.we1l.tools.Language.dialog_opt_ok
import com.autotech.we1l.tools.Language.txt_v_covered_by_store_credit
import kotlinx.android.synthetic.main.dialog_fragment_order_result.*

class OrderResultDialogFragment : BaseDialogFragment() {

    companion object {
        const val TAG = "CartBillPriceDialogFragment"
    }

    // Vars:
    private var finalBill = 0f
    private var coveredByStoreCredit = 0f
    private var remainingBill = 0f
    private var addedStoreCredit = 0f
    private var storeCredit = 0f

    override fun onCreateDialog(savedInstanceState: Bundle?): Dialog {

        rootView = LayoutInflater.from(context).inflate(R.layout.dialog_fragment_order_result, null, false)

        finalBill = arguments!!.getFloat(ATTR_FINAL_BILL)
        coveredByStoreCredit = arguments!!.getFloat(ATTR_COVERED_BY_STORE_CREDIT)
        remainingBill = arguments!!.getFloat(ATTR_REMAINING_BILL)
        addedStoreCredit = arguments!!.getFloat(ATTR_ADDED_STORE_CREDIT)
        storeCredit = arguments!!.getFloat(ATTR_REMAINING_STORE_CREDIT)


        return AlertDialog.Builder(context!!)
                .setView(rootView)
                .setPositiveButton(AppLanguage.getString(dialog_opt_ok)) { dialog, which ->
                    User.cartProducts.clear()
                    MainActivity.updateCartBadge.update(User.cartProducts.size)
                    activity!!.finish()
                }
                .setCancelable(false)
                .create()
    }

    @SuppressLint("SetTextI18n")
    override fun setupViews() {
        val currency = User.loadCurrency(context!!)!!
        final_bill.text = "$finalBill ${currency.name}"
        if (!arguments!!.getBoolean(ATTR_IS_UNREGISTERED)) {
            covered_by_store_credit.text = "$coveredByStoreCredit ${currency.name}"
            remaining_bill.text = "$remainingBill ${currency.name}"
            added_store_credit.text = "$addedStoreCredit ${currency.name}"
            store_credit.text = "$storeCredit ${currency.name}"
        } else {
            covered_by_store_credit_layout.visibility = View.GONE
            remaining_bill_layout.visibility = View.GONE
            added_store_credit_layout.visibility = View.GONE
            store_credit_layout.visibility = View.GONE
        }
    }

    override fun setupLanguages() {
        super.setupLanguages()
        final_bill_title.text = AppLanguage.getString(attr_final_bill)
        covered_by_store_credit_title.text = AppLanguage.getString(txt_v_covered_by_store_credit)
        remaining_bill_title.text = AppLanguage.getString(attr_remaining_bill)
        added_store_credit_title.text = AppLanguage.getString(attr_added_store_credit)
        remaining_store_credit_title.text = AppLanguage.getString(attr_remaining_store_credit)
    }
}