package com.autotech.we1l.fragments.dialog_fragments

import android.app.AlertDialog
import android.app.Dialog
import android.content.Intent
import android.os.Bundle
import android.support.v4.app.DialogFragment
import android.support.v7.widget.LinearLayoutManager
import android.support.v7.widget.RecyclerView
import android.view.LayoutInflater
import android.view.View
import android.widget.TextView
import android.widget.Toast
import com.afollestad.materialdialogs.MaterialDialog
import com.autotech.we1l.R
import com.autotech.we1l.activities.MainActivity
import com.autotech.we1l.adapters.ColorImagesAdapter
import com.autotech.we1l.app.AppLanguage
import com.autotech.we1l.app.User
import com.autotech.we1l.items.CartProduct
import com.autotech.we1l.items.ColorImage
import com.autotech.we1l.items.Product
import com.autotech.we1l.my_classes.BaseAdapter
import com.autotech.we1l.my_classes.BaseList
import com.autotech.we1l.tools.ATTR_COLOR_ID
import com.autotech.we1l.tools.ATTR_PRODUCT
import com.autotech.we1l.tools.Language.attr_select_quantity
import com.autotech.we1l.tools.Language.btn_add_to_cart
import com.autotech.we1l.tools.Language.dialog_opt_no
import com.autotech.we1l.tools.Language.dialog_opt_yes
import com.autotech.we1l.tools.Language.dialog_product_already_exists
import com.autotech.we1l.tools.Language.toast_added_to_cart
import com.autotech.we1l.tools.Language.txt_v_select_color
import com.shawnlin.numberpicker.NumberPicker
import kotlinx.android.synthetic.main.dialog_fragment_amount_picker.*

class ProductAmountDialogFragment : DialogFragment() {

    private lateinit var rootView: View

    private lateinit var product: Product
    private lateinit var colorImageList: BaseList<ColorImage>
    private lateinit var colorImagesAdapter: ColorImagesAdapter
    private var colorId = 0
    private var colorUrl: String? = null

    private var value = 1

    override fun onCreateDialog(savedInstanceState: Bundle?): Dialog {

        rootView = LayoutInflater.from(context).inflate(R.layout.dialog_fragment_amount_picker, null,false)

        val textViewSelectColor = rootView.findViewById<TextView>(R.id.textViewSelectColor)
        val number_picker = rootView.findViewById<NumberPicker>(R.id.number_picker)

        product = (arguments!!.getSerializable(ATTR_PRODUCT) as Product?)!!
        colorId = arguments!!.getInt(ATTR_COLOR_ID)
        colorImageList = arguments!!.getSerializable("COLOR_ITEM") as BaseList<ColorImage>

        val recyclerViewColor = rootView.findViewById<RecyclerView>(R.id.recyclerViewColor)
        recyclerViewColor.setHasFixedSize(true)
        val layoutManager = LinearLayoutManager(recyclerViewColor.context)
        layoutManager.orientation = LinearLayoutManager.HORIZONTAL
        recyclerViewColor.layoutManager = layoutManager
        textViewSelectColor.text=AppLanguage.getString(txt_v_select_color)
        if (colorImageList.isEmpty()) textViewSelectColor.visibility = View.GONE

        colorImagesAdapter = ColorImagesAdapter(context!!, colorImageList, object : BaseAdapter.OnClickListener<ColorImage> {
            override fun onClick(holder: RecyclerView.ViewHolder, position: Int, colorImage: ColorImage) {
                colorId = colorImage.id!!
                colorUrl = colorImage.colorUrl
            }
        })

        recyclerViewColor.adapter = colorImagesAdapter

        return AlertDialog.Builder(context!!)
                .setPositiveButton(AppLanguage.getString(btn_add_to_cart)) { _, _ ->
                    var currProduct: CartProduct? = null
                    User.cartProducts.forEachIndexed { _, cartProduct ->
                        if (cartProduct.product.id == product.id && cartProduct.colorId == colorId) {
                            currProduct = cartProduct
                        }
                    }
                    if (currProduct == null) {
                        if (colorImageList.isNotEmpty()) {
                            if (colorId == 0) {
                                Toast.makeText(context, "Please select a color", Toast.LENGTH_LONG).show()
                                return@setPositiveButton
                            } else {
                                User.addToCart(CartProduct(product, number_picker.value, colorId, colorUrl))
                                Toast.makeText(context, AppLanguage.getString(toast_added_to_cart), Toast.LENGTH_LONG).show()
                                dismiss()
                               startActivity(Intent(context, MainActivity::class.java))

                            }
                        } else {
                            User.addToCart(CartProduct(product, number_picker.value, colorId, colorUrl))
                            Toast.makeText(context, AppLanguage.getString(toast_added_to_cart), Toast.LENGTH_LONG).show()
                            dismiss()
                            startActivity(Intent(context, MainActivity::class.java))

                        }
                    } else {
                        MaterialDialog.Builder(context!!)
                                .content(AppLanguage.getString(dialog_product_already_exists) + " $value?")
                                .positiveText(AppLanguage.getString(dialog_opt_yes))
                                .onPositive { _, _ ->
                                    currProduct!!.quantity += number_picker.value
                                    currProduct!!.colorId = colorId
                                    dismiss()
                                }
                                .negativeText(AppLanguage.getString(dialog_opt_no))
                                .onNegative { _, _ ->
                                    dismiss()
                                }
                                .show()
                    }
                }
                .setTitle(AppLanguage.getString(attr_select_quantity))
                .setView(rootView)
                .create()
    }

    fun setupViews() {
        number_picker.setOnValueChangedListener { _, _, newVal ->
            value = newVal
        }
    }
}