package com.autotech.we1l.fragments.dialog_fragments

import android.annotation.SuppressLint
import android.app.AlertDialog
import android.app.Dialog
import android.content.Context
import android.os.Bundle
import android.view.LayoutInflater
import com.autotech.we1l.R
import com.autotech.we1l.app.AppLanguage
import com.autotech.we1l.my_classes.BaseDialogFragment
import com.autotech.we1l.tools.ATTR_IS_UNREGISTERED
import com.autotech.we1l.tools.SHARED_PREFERENCES_NAME
import com.autotech.we1l.tools.launchFirstActivity
import kotlinx.android.synthetic.main.include_not_logged_in.*

class UnregisteredPromptDialogFragment : BaseDialogFragment() {

    @SuppressLint("InflateParams")
    override fun onCreateDialog(savedInstanceState: Bundle?): Dialog {

        rootView = LayoutInflater.from(context).inflate(R.layout.include_not_logged_in,
                null, false)

        return AlertDialog.Builder(context!!)
                .setView(rootView)
                .create()
    }

    override fun setupViews() {
        super.setupViews()
        sign_in_or_sign_up.setOnClickListener {
            val sharedPreferences =
                    context!!.getSharedPreferences(SHARED_PREFERENCES_NAME, Context.MODE_PRIVATE)
            sharedPreferences.edit().putBoolean(ATTR_IS_UNREGISTERED, false).apply()
            launchFirstActivity(context!!)
        }
    }


    override fun setupLanguages() {
        super.setupLanguages()
        not_logged_in?.text = AppLanguage.getString(com.autotech.we1l.tools.Language.prompt_not_logged_in)
        sign_in_or_sign_up?.text = AppLanguage.getString(com.autotech.we1l.tools.Language.btn_sign_in_or_sign_up)
    }
}