package com.autotech.we1l.items

import com.autotech.we1l.my_classes.BaseItem
import com.autotech.we1l.tools.*
import org.json.JSONObject

class Ad(id: Int, val title: String, val content: String, val advertiser: String, val tel: String, val mobile: String,
         val imageUrl: String, val email: String, val type: String, val size: String) : BaseItem(id) {

    constructor(adJSON: JSONObject)
            : this(adJSON.getInt(ATTR_ID), adJSON.getString(ATTR_TITLE), adJSON.getString(ATTR_CONTENT),
            adJSON.getString(ATTR_NAME), adJSON.getString(ATTR_TEL), adJSON.getString(ATTR_MOBILE), adJSON.getString(ATTR_IMAGE_URL),
            adJSON.getString(ATTR_EMAIL), adJSON.getString(ATTR_TYPE), adJSON.getString(ATTR_PIXEL_SIZE))

    object Type {
        const val GOLD = "Gold"
        const val SILVER = "Silver"
        const val BRONZE = "Bronze"
    }

    object Size {
        const val FULL = "Full"
        const val MID = "Mid"
        const val SMALL = "Small"
    }

}