package com.autotech.we1l.items

import com.autotech.we1l.my_classes.BaseItem
import com.autotech.we1l.tools.*
import org.json.JSONObject

class BasePlace(val regionId: Int?, region: String?, city: String?, country: String?, val lat: Int?, val lon: Int?, val theName: String?)
    : BaseItem(if (country.isNullOrEmptyOrStringNull() || city.isNullOrEmptyOrStringNull() || region.isNullOrEmptyOrStringNull()) "$theName" else "$country - $city - $region") {

    constructor(myPlaceJSON: JSONObject)
            : this(myPlaceJSON.getInt(ATTR_REGION_ID),
            myPlaceJSON.getString(ATTR_REGION),
            myPlaceJSON.getString(ATTR_CITY),
            myPlaceJSON.getString(ATTR_COUNTRY),
            if (!myPlaceJSON.isNull(ATTR_LAT)) myPlaceJSON.getInt(ATTR_LAT) else 0,
            if (!myPlaceJSON.isNull(ATTR_LON)) myPlaceJSON.getInt(ATTR_LON) else 0,
            myPlaceJSON.getString(ATTR_NAME))
}