package com.autotech.we1l.items

import com.autotech.we1l.my_classes.BaseItem
import com.autotech.we1l.tools.*
import org.json.JSONObject

class Category(id: Int, name: String, val imageUrl: String, val isRectangle: Boolean, val childCategoriesIds: ArrayList<Int>) : BaseItem(id, name) {

    constructor(categoryJSON: JSONObject) :
            this(categoryJSON.getInt(ATTR_ID), categoryJSON.getString(ATTR_NAME),
                    categoryJSON.getString(ATTR_MOBILE_IMAGE_URL), categoryJSON.getBoolean(ATTR_IS_RECTANGLE),
                    ArrayList<Int>().apply {
                        val childCategoriesIds = categoryJSON.getJSONArray(ATTR_CHILD)
                        for (i in 0 until childCategoriesIds.length()) {
                            add(childCategoriesIds.getInt(i))
                        }
                    })
}