package com.autotech.we1l.items

import com.autotech.we1l.my_classes.BaseItem
import com.autotech.we1l.my_classes.BaseList
import com.autotech.we1l.tools.*
import org.json.JSONObject

class City(id: Int, name: String, private val lat: String, private val lon: String, val regions: BaseList<Region>) : BaseItem(id, name) {

    constructor(cityJSON: JSONObject) : this(cityJSON.getInt(ATTR_ID), cityJSON.getString(ATTR_NAME), cityJSON.getString(ATTR_LAT),
            cityJSON.getString(ATTR_LON), BaseList<Region>().apply {
        val regionsJSONArray = cityJSON.getJSONArray(ATTR_REGION)
        for (i in 0 until regionsJSONArray.length()) {
            add(Region(regionsJSONArray.getJSONObject(i)))
        }
    })

    override fun toString(): String {
        return "City(lat='$lat', lon='$lon', regions=$regions)"
    }

}