package com.autotech.we1l.items

import com.autotech.we1l.my_classes.BaseItem
import com.autotech.we1l.tools.ATTR_COLOR_ID
import com.autotech.we1l.tools.ATTR_COLOR_URL
import com.autotech.we1l.tools.ATTR_PRODUCT_IMAGES
import org.json.JSONArray
import org.json.JSONObject

class ColorImage(id: Int, val colorUrl: String, val productImages: ArrayList<String>, private val isNoColor: Boolean) : BaseItem(id) {

    constructor(jsonArray: JSONArray) : this(0, "", ArrayList<String>().apply {
        for (i in 0 until jsonArray.length()) {
            add(jsonArray.getString(i))
        }
    }, true)

    constructor(colorImagesJSONObject: JSONObject) : this(colorImagesJSONObject.getInt(ATTR_COLOR_ID),
            colorImagesJSONObject.getString(ATTR_COLOR_URL),
            ArrayList<String>().apply {
                val imagesUrl = colorImagesJSONObject.getJSONArray(ATTR_PRODUCT_IMAGES)
                for (i in 0 until imagesUrl.length()) {
                    add(imagesUrl.getString(i))
                }
            }, false)


}