package com.autotech.we1l.items

import com.autotech.we1l.my_classes.BaseItem
import com.autotech.we1l.my_classes.BaseList
import com.autotech.we1l.tools.*
import org.json.JSONObject

class Country(id: Int, name: String, private val currencyId: Int, private val code: String, private val lat: String,
              private val lon: String, val cities: BaseList<City>) : BaseItem(id, name) {

    constructor(countryJSON: JSONObject) : this(countryJSON.getInt(ATTR_ID), countryJSON.getString(ATTR_NAME),
            countryJSON.getInt(ATTR_CURRANCY_ID), countryJSON.getString(ATTR_CODE), countryJSON.getString(ATTR_LAT),
            countryJSON.getString(ATTR_LON), BaseList<City>().apply {
        val citiesJSONArray = countryJSON.getJSONArray(ATTR_CITY)
        for (i in 0 until citiesJSONArray.length()) {
            val cityJSON = citiesJSONArray.getJSONObject(i)
            add(City(cityJSON))
        }
    })

    override fun toString(): String {
        return "Country(currencyId=$currencyId, code='$code', lat='$lat', lon='$lon', cities=$cities)"
    }

}