package com.autotech.we1l.items

import android.os.Parcel
import com.autotech.we1l.my_classes.BaseItem
import com.autotech.we1l.tools.ATTR_FILE
import com.autotech.we1l.tools.ATTR_ID
import com.autotech.we1l.tools.ATTR_NAME
import com.autotech.we1l.tools.ATTR_SYMBOL
import org.json.JSONObject

class LanguageItem(id: Int, name: String, val symbol: String, val url: String) : BaseItem(id, name) {

    constructor(parcel: Parcel) : this(
            parcel.readInt(),
            parcel.readString()!!,
            parcel.readString()!!,
            parcel.readString()!!)

    constructor(languageJSON: JSONObject)
            : this(languageJSON.getInt(ATTR_ID), languageJSON.getString(ATTR_NAME),
            languageJSON.getString(ATTR_SYMBOL), languageJSON.getString(ATTR_FILE))
}