package com.autotech.we1l.items

import com.autotech.we1l.my_classes.BaseItem
import com.autotech.we1l.my_classes.BaseList
import com.autotech.we1l.tools.ATTR_ID
import com.autotech.we1l.tools.ATTR_NAME
import com.autotech.we1l.tools.ATTR_PRODUCTS
import org.json.JSONObject

class MiniCategory(id: Int, name: String, val miniProducts: BaseList<MiniProduct>) : BaseItem(id, name) {

    constructor(categoryMiniJSON: JSONObject)
            : this(categoryMiniJSON.getInt(ATTR_ID), categoryMiniJSON.getString(ATTR_NAME), BaseList<MiniProduct>().apply {
        val productMinis = categoryMiniJSON.getJSONArray(ATTR_PRODUCTS)
        for (i in 0 until productMinis.length()) {
            add(MiniProduct(productMinis.getJSONObject(i)))
        }
    })

}