package com.autotech.we1l.items

import com.autotech.we1l.my_classes.BaseItem
import com.autotech.we1l.my_classes.BaseList
import com.autotech.we1l.tools.*
import org.json.JSONObject
import java.util.*

class Order(id: Int, val orderNumber: String, val awbNumber: String, val address: String, val status: String, val date: Calendar,
            val invoiceDetails: BaseList<InvoiceDetail>) : BaseItem(id) {

    constructor(orderJSON: JSONObject)
            : this(orderJSON.getInt(ATTR_ID), orderJSON.getString(ATTR_ORDER_NUMBER), orderJSON.getString(ATTR_AWB_NUMBER),
            orderJSON.getString(ATTR_ADDRESS), orderJSON.getString(ATTR_STATUS),
            Calendar.getInstance().apply { timeInMillis = orderJSON.getLong(ATTR_ADD_DATE_TIME) * 1000 },
            BaseList<InvoiceDetail>().apply {
                val invoiceDetails = orderJSON.getJSONArray(ATTR_INVOICE_DETAILS)
                for (i in 0 until invoiceDetails.length()) {
                    add(InvoiceDetail(invoiceDetails.getJSONObject(i)))
                }
            })


}